/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.transport.activemq;

import com.activequant.domainmodel.PersistentEntity;
import com.activequant.transport.IPublisher;
import com.activequant.utils.MapToString;
import java.util.Map;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;

class JMSPublisher
implements IPublisher {
    private MessageProducer producer;
    private Session session;
    private MapToString mapToString = new MapToString();
    private Logger log = Logger.getLogger(JMSPublisher.class);
    private final String channelId;

    JMSPublisher(Session session, MessageProducer producer, String channelId) {
        this.producer = producer;
        this.session = session;
        this.channelId = channelId;
    }

    @Override
    public void send(Map<String, Object> message) throws Exception {
        String text = this.mapToString.convert(message);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[channelId=" + this.channelId + "] Message: " + text));
        }
        TextMessage tm = this.session.createTextMessage(text);
        tm.setStringProperty("channelId", this.channelId);
        this.producer.send((Message)tm);
    }

    @Override
    public void send(PersistentEntity entity) throws Exception {
        this.send(entity.propertyMap());
    }
}

