/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.transport.activemq;

import com.activequant.domainmodel.PersistentEntity;
import com.activequant.transport.IReceiver;
import com.activequant.utils.MapToString;
import com.activequant.utils.events.Event;
import com.activequant.utils.events.IEventSource;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.log4j.Logger;

class JMSReceiver
implements IReceiver,
MessageListener {
    private Logger log = Logger.getLogger((String)JMSReceiver.class.getName());
    private Event<Map<String, Object>> rawMsgRecEvent = new Event();
    private Event<PersistentEntity> msgRecEvent = new Event();
    private MapToString mapToString = new MapToString();

    JMSReceiver() {
    }

    @Override
    public IEventSource<Map<String, Object>> getRawMsgRecEvent() {
        return this.rawMsgRecEvent;
    }

    @Override
    public IEventSource<PersistentEntity> getMsgRecEvent() {
        return this.msgRecEvent;
    }

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            try {
                String text = textMessage.getText();
                Map<String, Object> map = this.mapToString.convert(text);
                this.rawMsgRecEvent.fire(map);
                if (map.containsKey("CLASSNAME")) {
                    try {
                        Class<?> clazz = Class.forName((String)map.get("CLASSNAME"));
                        PersistentEntity pe = (PersistentEntity)clazz.newInstance();
                        pe.initFromMap(map);
                        this.msgRecEvent.fire(pe);
                    }
                    catch (ClassNotFoundException e) {
                        this.log.warn((Object)"Map containing classname, but could not instantiate it. ", (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (JMSException e) {
                this.log.warn((Object)"Error while receiving message", (Throwable)e);
            }
        }
    }
}

