/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.transport.memory;

import com.activequant.domainmodel.Instrument;
import com.activequant.domainmodel.MarketDataInstrument;
import com.activequant.domainmodel.PersistentEntity;
import com.activequant.domainmodel.TradeableInstrument;
import com.activequant.exceptions.TransportException;
import com.activequant.transport.ETransportType;
import com.activequant.transport.IPublisher;
import com.activequant.transport.IReceiver;
import com.activequant.transport.ITransportFactory;
import com.activequant.transport.memory.InMemoryPublisher;
import com.activequant.transport.memory.InMemoryReceiver;
import com.activequant.utils.events.Event;
import java.util.HashMap;
import java.util.Map;

public class InMemoryTransportFactory
implements ITransportFactory {
    private Map<String, Event<Map<String, Object>>> rawEventMap = new HashMap<String, Event<Map<String, Object>>>();
    private Map<String, Event<PersistentEntity>> eventMap = new HashMap<String, Event<PersistentEntity>>();
    private Map<String, IPublisher> publisherMap = new HashMap<String, IPublisher>();
    private Map<String, IReceiver> recvMap = new HashMap<String, IReceiver>();

    private Event<Map<String, Object>> getRawEventInstance(String channelName) {
        if (!this.rawEventMap.containsKey(channelName)) {
            this.rawEventMap.put(channelName, new Event());
        }
        return this.rawEventMap.get(channelName);
    }

    private Event<PersistentEntity> getEventInstance(String channelName) {
        if (!this.eventMap.containsKey(channelName)) {
            this.eventMap.put(channelName, new Event());
        }
        return this.eventMap.get(channelName);
    }

    private IPublisher getIPub(String channelName) {
        if (!this.publisherMap.containsKey(channelName)) {
            InMemoryPublisher p = new InMemoryPublisher(this.getRawEventInstance(channelName), this.getEventInstance(channelName));
            this.publisherMap.put(channelName, p);
        }
        return this.publisherMap.get(channelName);
    }

    private IReceiver getIRecv(String channelName) {
        if (!this.recvMap.containsKey(channelName)) {
            InMemoryReceiver p = new InMemoryReceiver(this.getRawEventInstance(channelName), this.getEventInstance(channelName));
            this.recvMap.put(channelName, p);
        }
        return this.recvMap.get(channelName);
    }

    @Override
    public IPublisher getPublisher(ETransportType transType, String id) throws TransportException {
        String channelName = transType.toString() + ":" + id;
        return this.getIPub(channelName);
    }

    @Override
    public IReceiver getReceiver(ETransportType transType, String id) throws TransportException {
        String channelName = transType.toString() + ":" + id;
        return this.getIRecv(channelName);
    }

    @Override
    public IPublisher getPublisher(ETransportType transType, Instrument instrument) throws TransportException {
        String channelName = transType.toString() + ":" + instrument.getId();
        return this.getIPub(channelName);
    }

    @Override
    public IReceiver getReceiver(ETransportType transType, Instrument instrument) throws TransportException {
        String channelName = transType.toString() + ":" + instrument.getId();
        return this.getIRecv(channelName);
    }

    @Override
    public IPublisher getPublisher(ETransportType transType, MarketDataInstrument instrument) throws TransportException {
        String channelName = transType.toString() + ":" + instrument.getId();
        return this.getIPub(channelName);
    }

    @Override
    public IReceiver getReceiver(ETransportType transType, MarketDataInstrument instrument) throws TransportException {
        String channelName = transType.toString() + ":" + instrument.getId();
        return this.getIRecv(channelName);
    }

    @Override
    public IPublisher getPublisher(ETransportType transType, TradeableInstrument instrument) throws TransportException {
        String channelName = transType.toString() + ":" + instrument.getId();
        return this.getIPub(channelName);
    }

    @Override
    public IReceiver getReceiver(ETransportType transType, TradeableInstrument instrument) throws TransportException {
        String channelName = transType.toString() + ":" + instrument.getId();
        return this.getIRecv(channelName);
    }

    @Override
    public IPublisher getPublisher(String channel) throws TransportException {
        return this.getIPub(channel);
    }

    @Override
    public IReceiver getReceiver(String channel) throws TransportException {
        return this.getIRecv(channel);
    }
}

