/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils;

import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

public class ArrayUtils {
    public static <T> T[] asArray(Collection<T> list, Class<T> clazz) {
        Object[] emptyArray = (Object[])Array.newInstance(clazz, 0);
        return list == null ? emptyArray : list.toArray(emptyArray);
    }

    public static <T> List<T> asList(T[] array) {
        return array == null ? new ArrayList() : new ArrayList<T>(Arrays.asList(array));
    }

    public static <T> Vector<T> asVector(T[] array) {
        return array == null ? new Vector() : new Vector<T>(Arrays.asList(array));
    }

    public static <T> void reverse(T[] b) {
        int left = 0;
        for (int right = b.length - 1; left < right; ++left, --right) {
            T temp = b[left];
            b[left] = b[right];
            b[right] = temp;
        }
    }

    public static void reverse(double[] b) {
        int left = 0;
        for (int right = b.length - 1; left < right; ++left, --right) {
            double temp = b[left];
            b[left] = b[right];
            b[right] = temp;
        }
    }

    public static String toString(Double[] input) {
        StringBuilder ret = new StringBuilder();
        for (Double o : input) {
            ret.append("");
            ret.append("" + o);
            ret.append(" ");
        }
        return ret.toString();
    }

    public static String toString(double[] input) {
        StringBuilder ret = new StringBuilder();
        for (double o : input) {
            ret.append(DecimalFormat.getInstance().format(o));
            ret.append(", ");
        }
        ret.delete(ret.length() - 2, ret.length());
        return ret.toString();
    }

    public static String toString(String[] input) {
        StringBuilder ret = new StringBuilder();
        for (String o : input) {
            ret.append(o);
            ret.append(", ");
        }
        if (ret.length() > 2) {
            ret.delete(ret.length() - 2, ret.length());
        }
        return ret.toString();
    }

    public static String toString(Double[][] input) {
        StringBuilder ret = new StringBuilder();
        for (Double[] o : input) {
            ret.append(ArrayUtils.toString(o));
            ret.append("\n");
        }
        return ret.toString();
    }

    public static double[] convert(Collection<Double> list) {
        return ArrayUtils.convert(list.toArray(new Double[0]));
    }

    public static double[] convert(Double[] in) {
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i];
        }
        return ret;
    }

    public static Double[] convert(double[] in) {
        Double[] ret = new Double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i];
        }
        return ret;
    }

    public static double[][] convert(Double[][] in) {
        double[][] ret = new double[in.length][in[0].length];
        for (int i = 0; i < in.length; ++i) {
            for (int j = 0; j < in[0].length; ++j) {
                ret[i][j] = in[i][j];
            }
        }
        return ret;
    }
}

