/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils;

import com.activequant.utils.events.Event;
import com.activequant.utils.events.IEventListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class CsvMapReader {
    private String[] headerNames = null;

    public void setHeader(String[] header) {
        this.headerNames = header;
    }

    public void read(IEventListener<Map<String, String>> eventListener, InputStream inputStream) throws Exception {
        int rowCount = 1;
        String errorLine = "";
        try {
            Event<Map<String, String>> event = new Event<Map<String, String>>();
            event.addEventListener(eventListener);
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            if (this.headerNames == null) {
                String header = br.readLine();
                this.headerNames = header.split(",");
            }
            String line = br.readLine();
            while (line != null) {
                errorLine = line;
                ++rowCount;
                line.replaceAll("\"", "");
                line.replaceAll("'", "");
                line = line.trim();
                String[] content = line.split(",");
                HashMap<String, String> map = new HashMap<String, String>();
                for (int i = 0; i < content.length; ++i) {
                    String trimmedH = this.headerNames[i].trim();
                    String trimmedC = content[i].trim();
                    map.put(trimmedH, trimmedC);
                }
                event.fire(map);
                line = br.readLine();
            }
        }
        catch (Exception ex) {
            throw new Exception("Error while parsing CSV stream, line " + rowCount + ": " + errorLine, ex);
        }
    }
}

