/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String source, String dest) throws IOException {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            in = new FileInputStream(source).getChannel();
            out = new FileOutputStream(dest).getChannel();
            long size = in.size();
            MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            ((FileChannel)out).write(buf);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void move(String source, String dest) throws IOException {
        FileUtils.copy(source, dest);
        new File(source).delete();
    }

    public static String check(String dir) {
        FileUtils.mkdir(dir);
        return FileUtils.appendSlash(dir);
    }

    public static void mkdir(String dir) {
        if (!new File(dir).exists()) {
            new File(dir).mkdirs();
        }
    }

    public static String appendSlash(String dir) {
        return dir.endsWith(File.separator) ? dir : dir + File.separator;
    }

    public static String[] readLines(String fileName) throws IOException {
        return FileUtils.readLines(new FileInputStream(fileName));
    }

    public static String[] readLines(InputStream in) throws IOException {
        ArrayList<String> r = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String l = br.readLine();
        while (l != null) {
            r.add(l);
            l = br.readLine();
        }
        return r.toArray(new String[0]);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

