/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils;

public class IdentityUtils {
    public static boolean areEqual(boolean aThis, boolean aThat) {
        return aThis == aThat;
    }

    public static boolean areEqual(char aThis, char aThat) {
        return aThis == aThat;
    }

    public static boolean areEqual(long aThis, long aThat) {
        return aThis == aThat;
    }

    public static boolean areEqual(float aThis, float aThat) {
        return Float.floatToIntBits(aThis) == Float.floatToIntBits(aThat);
    }

    public static boolean areEqual(double aThis, double aThat) {
        return Double.doubleToLongBits(aThis) == Double.doubleToLongBits(aThat);
    }

    public static boolean areEqual(Object aThis, Object aThat) {
        return aThis == null ? aThat == null : aThis.equals(aThat);
    }

    public static <T extends Comparable<T>> int safeCompare(T o1, T o2) {
        if (o1 != null) {
            return o2 == null ? 1 : IdentityUtils.compare(o1, o2);
        }
        return o2 == null ? 0 : -1;
    }

    private static <T extends Comparable<T>> int compare(T o1, T o2) {
        if (o1.getClass().equals(o2.getClass())) {
            return o1.compareTo(o2);
        }
        throw new AssertionError((Object)("attempt to compare incomaparable: " + o1 + " " + o2 + ", " + o1.getClass() + " " + o2.getClass()));
    }

    public static int safeCompare(int o1, int o2) {
        return o1 - o2;
    }

    public static int safeCompare(long o1, long o2) {
        return o1 > o2 ? 1 : (o1 < o2 ? -1 : 0);
    }

    public static int safeCompare(char o1, char o2) {
        return o1 > o2 ? 1 : (o1 < o2 ? -1 : 0);
    }

    public static int safeCompare(byte o1, byte o2) {
        return o1 > o2 ? 1 : (o1 < o2 ? -1 : 0);
    }

    public static <T> int safeHashCode(T o) {
        return o == null ? 0 : o.hashCode();
    }

    public static int safeHashCode(int i) {
        return i;
    }

    public static int safeHashCode(long i) {
        return (int)i;
    }

    public static int safeHashCode(char i) {
        return i;
    }

    public static int safeHashCode(byte i) {
        return i;
    }

    public static <T extends Comparable<T>> boolean equalsTo(T o1, Object o2) {
        assert (o1 != null);
        if (o1 == o2) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (o2.getClass() == o1.getClass()) {
            return o1.compareTo((Comparable)((Comparable)o2)) == 0;
        }
        return false;
    }
}

