/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils;

import com.activequant.archive.IArchiveFactory;
import com.activequant.archive.IArchiveWriter;
import com.activequant.dao.IDaoFactory;
import com.activequant.dao.IInstrumentDao;
import com.activequant.dao.IMarketDataInstrumentDao;
import com.activequant.domainmodel.MarketDataInstrument;
import com.activequant.domainmodel.TimeFrame;
import com.activequant.domainmodel.TimeStamp;
import com.activequant.utils.CsvMapReader;
import com.activequant.utils.FileTraversal;
import com.activequant.utils.events.IEventListener;
import com.activequant.utils.worker.Worker;
import com.activequant.utils.worker.WorkerThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ImportBBTickDump {
    private final ApplicationContext appContext;
    private final IDaoFactory idf;
    private final IMarketDataInstrumentDao mdiDao;
    private final IInstrumentDao idao;
    private LinkedBlockingQueue<String> fileNameQueue = new LinkedBlockingQueue();
    private String mdProvider;
    private IArchiveFactory archiveFactory;
    private TimeFrame timeFrame;

    public ImportBBTickDump(String directory, String mdprovider, String springInitFile, TimeFrame inTimeFrame) throws Exception {
        this.appContext = new ClassPathXmlApplicationContext(springInitFile);
        this.idf = (IDaoFactory)this.appContext.getBean("ibatisDao");
        this.mdiDao = this.idf.mdiDao();
        this.idao = this.idf.instrumentDao();
        this.archiveFactory = (IArchiveFactory)this.appContext.getBean("archiveFactory", IArchiveFactory.class);
        this.timeFrame = inTimeFrame;
        this.mdProvider = mdprovider;
        new FileTraversal(){

            @Override
            public void onFile(File f) {
                System.out.println(f);
                if (f.getName().toLowerCase().endsWith(".csv")) {
                    try {
                        ImportBBTickDump.this.fileNameQueue.add(f.getAbsolutePath());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }.traverse(new File(directory));
        for (int i = 0; i < 100; ++i) {
            this.fileNameQueue.add("TERMINATE");
        }
        new Thread(new WorkerThread<String>(this.fileNameQueue, new AnonymousWorker())).start();
        new Thread(new WorkerThread<String>(this.fileNameQueue, new AnonymousWorker())).start();
    }

    public static void main(String[] args) throws Exception {
        String startFolder = args[0];
        String mdprovider = args[1];
        String springFile = args[2];
        String timeFrame = args[3];
        System.out.println("Importing from " + startFolder + " all .csv files for " + mdprovider + ". Using spring configuration " + springFile + " and time frame " + timeFrame);
        new ImportBBTickDump(startFolder, mdprovider, springFile, TimeFrame.valueOf(timeFrame));
    }

    class AnonymousWorker
    extends Worker<String> {
        private IArchiveWriter iaw;
        int lineCounter;

        AnonymousWorker() {
            this.iaw = ImportBBTickDump.this.archiveFactory.getWriter(ImportBBTickDump.this.timeFrame);
            this.lineCounter = 0;
        }

        @Override
        public void process(String event) {
            this.lineCounter = 0;
            if (event.equals("TERMINATE")) {
                this.setRunFlag(false);
                return;
            }
            System.out.println("********* Processing file name >" + event + "<");
            File f = new File(event);
            System.out.println("********* Created file. ");
            try {
                this.importFile(f.getAbsolutePath(), f.getName().substring(0, f.getName().toLowerCase().indexOf(".csv")).trim(), ImportBBTickDump.this.mdProvider);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void importFile(String fileName, String providerspecificid, String mdprovider) throws Exception {
            System.out.println("Importing " + fileName + " / " + mdprovider + " / " + providerspecificid);
            Pattern p = Pattern.compile("[A-Z][0123456789] ");
            for (int i = 0; i < 9; ++i) {
                if (!p.matcher(providerspecificid).find()) continue;
                providerspecificid = providerspecificid.replaceAll("" + i, "1" + i);
            }
            MarketDataInstrument tempMdi = ImportBBTickDump.this.mdiDao.findByProvId(mdprovider, providerspecificid);
            if (tempMdi == null) {
                tempMdi = new MarketDataInstrument();
                tempMdi.setProviderSpecificId(providerspecificid);
                tempMdi.setMdProvider(mdprovider);
                ImportBBTickDump.this.mdiDao.create(tempMdi);
            }
            final MarketDataInstrument mdi = tempMdi;
            tempMdi = null;
            final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            System.out.println("All set, ready to parse for " + mdi.getId() + " /// " + System.currentTimeMillis());
            long l1 = System.currentTimeMillis();
            CsvMapReader cmr = new CsvMapReader();
            cmr.setHeader(new String[]{"TIMESTAMP", "TYPE", "PRICE", "QUANTITY", "IND"});
            cmr.read(new IEventListener<Map<String, String>>(){

                @Override
                public void eventFired(Map<String, String> event) {
                    String dateTime = event.get("TIMESTAMP");
                    String type = event.get("TYPE");
                    String price = event.get("PRICE");
                    String quantity = event.get("QUANTITY");
                    try {
                        TimeStamp ts = new TimeStamp(sdf.parse(dateTime));
                        AnonymousWorker.this.iaw.write(mdi.getId(), ts, type, Double.parseDouble(price));
                        AnonymousWorker.this.iaw.write(mdi.getId(), ts, type + "QUANTITY", Double.parseDouble(quantity));
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                    if (AnonymousWorker.this.lineCounter++ > 100) {
                        AnonymousWorker.this.lineCounter = 0;
                        try {
                            AnonymousWorker.this.iaw.commit();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, new FileInputStream(fileName));
            this.iaw.commit();
            long l2 = System.currentTimeMillis();
            System.out.println("Took: " + (l2 - l1));
        }
    }
}

