/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils;

import com.activequant.dao.DaoException;
import com.activequant.dao.IDaoFactory;
import com.activequant.dao.IInstrumentDao;
import com.activequant.domainmodel.Instrument;
import com.activequant.utils.CsvMapReader;
import com.activequant.utils.InstanceFromMapInstantiator;
import com.activequant.utils.events.IEventListener;
import java.io.FileInputStream;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ImportInstrumentsCSV {
    private final ApplicationContext appContext;
    private final IDaoFactory idf;
    private final IInstrumentDao idao;
    private Logger log = Logger.getLogger(this.getClass());

    public ImportInstrumentsCSV(String fileName, String springInitFile) throws Exception {
        this.appContext = new ClassPathXmlApplicationContext(springInitFile);
        this.idf = (IDaoFactory)this.appContext.getBean("ibatisDao");
        this.idao = this.idf.instrumentDao();
        final InstanceFromMapInstantiator i = new InstanceFromMapInstantiator();
        CsvMapReader cmr = new CsvMapReader();
        cmr.read(new IEventListener<Map<String, String>>(){

            @Override
            public void eventFired(Map<String, String> event) {
                Instrument instr = (Instrument)i.loadStringString(event);
                try {
                    ImportInstrumentsCSV.this.idao.update(instr);
                    ImportInstrumentsCSV.this.log.info((Object)("Created or updated instrument" + instr.getId()));
                }
                catch (DaoException e) {
                    ImportInstrumentsCSV.this.log.warn((Object)("Error while importing " + event), (Throwable)e);
                    e.printStackTrace();
                }
            }
        }, new FileInputStream(fileName));
    }

    public static void main(String[] args) throws Exception {
        String fileName = args[0];
        String springFile = args[1];
        System.out.println("Importing from " + fileName + ". Using spring configuration " + springFile);
        new ImportInstrumentsCSV(fileName, springFile);
    }
}

