/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils;

import com.activequant.dao.DaoException;
import com.activequant.dao.IDaoFactory;
import com.activequant.dao.IMarketDataInstrumentDao;
import com.activequant.domainmodel.MarketDataInstrument;
import com.activequant.utils.CsvMapReader;
import com.activequant.utils.InstanceFromMapInstantiator;
import com.activequant.utils.events.IEventListener;
import java.io.FileInputStream;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ImportMarketDataInstrumentsCSV {
    private final ApplicationContext appContext;
    private final IDaoFactory idf;
    private final IMarketDataInstrumentDao mdiDao;
    private final Logger log = Logger.getLogger(this.getClass());

    public ImportMarketDataInstrumentsCSV(String fileName, String springInitFile) throws Exception {
        this.appContext = new ClassPathXmlApplicationContext(springInitFile);
        this.idf = (IDaoFactory)this.appContext.getBean("ibatisDao");
        this.mdiDao = this.idf.mdiDao();
        final InstanceFromMapInstantiator i = new InstanceFromMapInstantiator();
        CsvMapReader cmr = new CsvMapReader();
        cmr.read(new IEventListener<Map<String, String>>(){

            @Override
            public void eventFired(Map<String, String> event) {
                MarketDataInstrument instr = (MarketDataInstrument)i.loadStringString(event);
                try {
                    ImportMarketDataInstrumentsCSV.this.mdiDao.update(instr);
                    ImportMarketDataInstrumentsCSV.this.log.info((Object)("Updated or created instrument: " + instr.getId()));
                }
                catch (DaoException e) {
                    System.err.println("Error while importing " + event);
                    e.printStackTrace();
                }
            }
        }, new FileInputStream(fileName));
    }

    public static void main(String[] args) throws Exception {
        String fileName = args[0];
        String springFile = args[1];
        System.out.println("Importing from " + fileName + ". Using spring configuration " + springFile);
        new ImportMarketDataInstrumentsCSV(fileName, springFile);
    }
}

