/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils;

import com.activequant.archive.IArchiveFactory;
import com.activequant.archive.IArchiveWriter;
import com.activequant.dao.IDaoFactory;
import com.activequant.dao.IInstrumentDao;
import com.activequant.dao.IMarketDataInstrumentDao;
import com.activequant.domainmodel.MarketDataInstrument;
import com.activequant.domainmodel.TimeFrame;
import com.activequant.domainmodel.TimeStamp;
import com.activequant.utils.CsvMapReader;
import com.activequant.utils.Date8Time6Parser;
import com.activequant.utils.events.IEventListener;
import com.activequant.utils.worker.Worker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ImportPriceSheet {
    private final ApplicationContext appContext;
    private final IDaoFactory idf;
    private final IMarketDataInstrumentDao mdiDao;
    private final IInstrumentDao idao;
    private LinkedBlockingQueue<String> fileNameQueue = new LinkedBlockingQueue();
    private String mdProvider;
    private IArchiveFactory archiveFactory;
    private TimeFrame timeFrame;

    public ImportPriceSheet(String filename, String mdprovider, String springInitFile, TimeFrame inTimeFrame) throws Exception {
        this.appContext = new ClassPathXmlApplicationContext(springInitFile);
        this.idf = (IDaoFactory)this.appContext.getBean("ibatisDao");
        this.mdiDao = this.idf.mdiDao();
        this.idao = this.idf.instrumentDao();
        this.archiveFactory = (IArchiveFactory)this.appContext.getBean("archiveFactory", IArchiveFactory.class);
        this.timeFrame = inTimeFrame;
        this.mdProvider = mdprovider;
        new AnonymousWorker().process(filename);
    }

    public static void main(String[] args) throws Exception {
        String startFolder = args[0];
        String mdprovider = args[1];
        String springFile = args[2];
        String timeFrame = args[3];
        System.out.println("Importing from " + startFolder + " all .csv files for " + mdprovider + ". Using spring configuration " + springFile + " and time frame " + timeFrame);
        new ImportPriceSheet(startFolder, mdprovider, springFile, TimeFrame.valueOf(timeFrame));
    }

    class AnonymousWorker
    extends Worker<String> {
        private IArchiveWriter iaw;
        int lineCounter;

        AnonymousWorker() {
            this.iaw = ImportPriceSheet.this.archiveFactory.getWriter(ImportPriceSheet.this.timeFrame);
            this.lineCounter = 0;
        }

        @Override
        public void process(String event) {
            this.lineCounter = 0;
            if (event.equals("TERMINATE")) {
                this.setRunFlag(false);
                return;
            }
            System.out.println("********* Processing file name >" + event + "<");
            File f = new File(event);
            System.out.println("********* Created file. ");
            try {
                this.importFile(f.getAbsolutePath(), ImportPriceSheet.this.mdProvider);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void importFile(String fileName, final String mdprovider) throws Exception {
            System.out.println("Importing " + fileName + " / " + mdprovider);
            Date8Time6Parser d8t6p = new Date8Time6Parser();
            final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");
            final SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            sdf2.setTimeZone(TimeZone.getTimeZone("UTC"));
            long l1 = System.currentTimeMillis();
            CsvMapReader cmr = new CsvMapReader();
            cmr.read(new IEventListener<Map<String, String>>(){

                @Override
                public void eventFired(Map<String, String> event) {
                    String date = event.get("Date");
                    if (date == null) {
                        date = event.get("DATE");
                    }
                    Long dl = Long.parseLong(date);
                    long seconds = (dl - 25569L) * 86400L;
                    Date d = new Date(seconds * 1000L);
                    String time = "23:59:00.000";
                    SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
                    String dateTime = yyyyMMdd.format(d);
                    dateTime = dateTime + " " + time;
                    Iterator<Map.Entry<String, String>> it = event.entrySet().iterator();
                    try {
                        TimeStamp ts = dateTime.indexOf("-") != -1 ? new TimeStamp(sdf2.parse(dateTime)) : new TimeStamp(sdf.parse(dateTime));
                        while (it.hasNext()) {
                            MarketDataInstrument mdi;
                            Map.Entry<String, String> entry = it.next();
                            String key = entry.getKey();
                            if (key.toUpperCase().equals("DATE") || key.toUpperCase().equals("TIME") || (mdi = ImportPriceSheet.this.mdiDao.findByProvId(mdprovider, key)) == null || entry.getValue().equals("#")) continue;
                            System.out.println("Importing : " + ts.getDate() + " - " + key + " - " + entry.getValue());
                            AnonymousWorker.this.iaw.write(mdi.getId(), ts, "PX_SETTLE", Double.parseDouble(entry.getValue()));
                            if (AnonymousWorker.this.lineCounter++ <= 100) continue;
                            AnonymousWorker.this.lineCounter = 0;
                            try {
                                AnonymousWorker.this.iaw.commit();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                }
            }, new FileInputStream(fileName));
            this.iaw.commit();
            long l2 = System.currentTimeMillis();
            System.out.println("Took: " + (l2 - l1));
        }
    }
}

