/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils;

import com.activequant.utils.ActiveQuantDataField;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class MapToString {
    private static Logger log = Logger.getLogger(MapToString.class);

    public String convert(Map<String, Object> mapIn) {
        StringBuffer r = new StringBuffer();
        Iterator<String> keyIterator = mapIn.keySet().iterator();
        Iterator<Object> valueIterator = mapIn.values().iterator();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            Object value = valueIterator.next();
            r.append(key);
            r.append("=");
            r.append(value.toString());
            r.append(";");
        }
        return r.toString();
    }

    public Map<String, Object> convert(String sIn) {
        String[] keyVals;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String s : keyVals = sIn.split(";")) {
            if (s.length() == 0) continue;
            String[] keyVal = s.split("=");
            if (keyVal.length != 2) {
                log.warn((Object)("Invalid value received: " + s));
                continue;
            }
            String key = keyVal[0];
            try {
                ActiveQuantDataField field = ActiveQuantDataField.valueOf(key);
                if (field != null) {
                    ret.put(key, field.getValueObject(keyVal[1]));
                    continue;
                }
                log.warn((Object)("No AimHedgeDataField found for feed key >>" + key + "<<"));
            }
            catch (Exception ex) {
                if (this.tryDouble(keyVal[1]) != null) {
                    ret.put(key, this.tryDouble(keyVal[1]));
                    continue;
                }
                if (this.tryString(keyVal[1]) != null) {
                    ret.put(key, this.tryString(keyVal[1]));
                    continue;
                }
                log.warn((Object)"Dropping unconvertable value");
            }
        }
        return ret;
    }

    private Double tryDouble(String val) {
        try {
            return Double.parseDouble(val);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String tryString(String val) {
        try {
            return val;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

