/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils;

import com.activequant.domainmodel.TimeStamp;
import java.util.Date;

public class UniqueTimeStampGenerator {
    private static long AMBIGUATION_UNITS_IN_MILLIS = 1000000L;
    private long lastMillis = 0L;
    private long nanos = 0L;

    public TimeStamp now() {
        return this.generate(new Date());
    }

    public TimeStamp generate(Date input) {
        long time = input.getTime();
        return this.generate(time);
    }

    public TimeStamp generate(long inputInMilliseconds) {
        if (inputInMilliseconds > this.lastMillis) {
            this.lastMillis = inputInMilliseconds;
            this.nanos = 0L;
        } else if (inputInMilliseconds == this.lastMillis) {
            ++this.nanos;
            if (this.nanos >= AMBIGUATION_UNITS_IN_MILLIS) {
                throw new AssertionError((Object)"failed to disambiguate");
            }
        } else {
            throw new AssertionError((Object)("input dates are out-of-order : " + inputInMilliseconds + " is lower than " + this.lastMillis));
        }
        return new TimeStamp(this.lastMillis * AMBIGUATION_UNITS_IN_MILLIS + this.nanos);
    }
}

