/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils.checks;

import com.activequant.dao.IDaoFactory;
import com.activequant.dao.IInstrumentDao;
import com.activequant.dao.IMarketDataInstrumentDao;
import com.activequant.domainmodel.TimeStamp;
import com.activequant.utils.ArrayUtils;
import com.activequant.utils.mail.SendMail;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CheckScript {
    private final ApplicationContext appContext;
    private final IDaoFactory idf;
    private final IInstrumentDao idao;
    private final IMarketDataInstrumentDao mdiDao;
    private SendMail sendMail;

    public CheckScript(String springInitFile, String target) throws Exception {
        this.appContext = new ClassPathXmlApplicationContext(springInitFile);
        this.sendMail = (SendMail)this.appContext.getBean("sendMail");
        this.idf = (IDaoFactory)this.appContext.getBean("ibatisDao");
        this.idao = this.idf.instrumentDao();
        this.mdiDao = this.idf.mdiDao();
        int rows = 100;
        int columns = 2;
        Object[][] data = new Object[rows][columns];
        int row = 0;
        this.setData(data, row++, "#Instruments", "" + this.idao.count());
        this.setData(data, row++, "#MDIs", "" + this.mdiDao.count());
        this.setData(data, row++, "#SecChains", "" + this.idf.securityChainDao().count());
        this.setData(data, row++, "#Tradeables", "" + this.idf.tradeableDao().count());
        this.setData(data, row++, "#Countries", "" + this.idf.countryDao().count());
        this.setData(data, row++, "#Venues", "" + this.idf.venueDao().count());
        String[] providers = this.mdiDao.getProviders();
        this.setData(data, row++, "Providers", "" + ArrayUtils.toString(providers));
        for (int i = 0; i < providers.length; ++i) {
            this.setData(data, row++, " #MDIs for " + providers[i], "" + this.mdiDao.countForAttributeValue("MDPROVIDER", providers[i]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date midnightThisMorning = sdf.parse(sdf.format(new Date()));
        String[] mdiids = this.mdiDao.findIDsWhereCreationDateBetween(new TimeStamp(midnightThisMorning), new TimeStamp());
        StringBuffer mailBody = new StringBuffer("<h1>General information</h1>" + this.sendMail.generateHtmlTable(new String[]{"Property", "Value"}, data));
        mailBody.append("<h1>New MDIs</h1>");
        for (String id : mdiids) {
            mailBody.append(id + "<br/>");
        }
        String[] instruments = this.idao.findIDsWhereCreationDateBetween(new TimeStamp(midnightThisMorning), new TimeStamp());
        mailBody.append("<h1>New Instruments</h1>");
        for (String id : instruments) {
            mailBody.append(id + "<br/>");
        }
        if (target.contains(",")) {
            this.sendMail.sendMail(target.split(","), "Statistics", mailBody.toString());
        } else {
            this.sendMail.sendMail(new String[]{target}, "Statistics", mailBody.toString());
        }
    }

    private void setData(Object[][] data, int row, String property, String value) {
        data[row][0] = property;
        data[row][1] = value;
    }

    public static void main(String[] args) throws Exception {
        String springFile = args[0];
        String target = args[1];
        System.out.println("Using spring configuration " + springFile + ". Sending to " + target);
        new CheckScript(springFile, target);
    }
}

