/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils.events;

import com.activequant.utils.events.IEventListener;
import com.activequant.utils.events.IEventSink;
import com.activequant.utils.events.IEventSource;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Event<T>
implements IEventSink<T>,
IEventSource<T> {
    private final Queue<IEventListener<T>> listeners = new ConcurrentLinkedQueue<IEventListener<T>>();

    @Override
    public void fire(T e) {
        for (IEventListener iEventListener : this.listeners) {
            iEventListener.eventFired(e);
        }
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    @Override
    public void addEventListener(IEventListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeEventListener(IEventListener<T> listener) {
        return this.listeners.remove(listener);
    }

    public void clear() {
        this.listeners.clear();
    }

    public void forward(final IEventSink<T> target) {
        this.listeners.add(new IEventListener<T>(){

            @Override
            public void eventFired(T event) {
                target.fire(event);
            }
        });
    }
}

