/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils.events;

import com.activequant.utils.events.IEventListener2;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Event2<T1, T2> {
    private final Queue<IEventListener2<T1, T2>> listeners = new ConcurrentLinkedQueue<IEventListener2<T1, T2>>();

    public void fire(T1 t1, T2 t2) throws Exception {
        for (IEventListener2 iEventListener2 : this.listeners) {
            iEventListener2.eventFired(t1, t2);
        }
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public IEventListener2<T1, T2> addEventListener(IEventListener2<T1, T2> listener) {
        this.listeners.add(listener);
        return listener;
    }

    public void removeEventListener(IEventListener2<T1, T2> listener) {
        this.listeners.remove(listener);
    }

    public void clear() {
        this.listeners.clear();
    }

    public void forward(final Event2<T1, T2> target) {
        this.listeners.add(new IEventListener2<T1, T2>(){

            @Override
            public void eventFired(T1 t1, T2 t2) throws Exception {
                target.fire(t1, t2);
            }
        });
    }
}

