/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils.mail;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SendMail {
    private String host;
    private String user;
    private String password;
    private String from;
    private int port;

    public SendMail(String host, int port, String username, String password, String from) {
        this.host = host;
        this.port = port;
        this.user = username;
        this.password = password;
        this.from = from;
    }

    public String generateHtmlTable(String[] header, Object[][] cells) {
        StringBuilder sb = new StringBuilder();
        sb.append("<table border='1'>");
        sb.append("<tr>");
        for (String s : header) {
            sb.append("<td><b>").append(s).append("</b></td>");
        }
        sb.append("</tr>");
        for (int i = 0; i < cells.length; ++i) {
            boolean append = false;
            String line = "<tr>";
            for (int j = 0; j < cells[i].length; ++j) {
                if (cells[i][j] != null) {
                    append = true;
                }
                line = line + "<td>" + cells[i][j] + "</td>";
            }
            line = line + "</tr>";
            if (!append) continue;
            sb.append(line);
        }
        sb.append("</table>");
        return sb.toString();
    }

    public void sendMail(String[] recipients, String subject, String htmlBody) throws Exception {
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.host", this.host);
        props.setProperty("mail.port", "" + this.port);
        props.setProperty("mail.user", this.user);
        props.setProperty("mail.password", this.password);
        Session mailSession = Session.getDefaultInstance((Properties)props, null);
        mailSession.setDebug(true);
        Transport transport = mailSession.getTransport();
        MimeMessage message = new MimeMessage(mailSession);
        message.setSubject(subject);
        message.setFrom((Address)new InternetAddress(this.from));
        message.setSentDate(new Date());
        for (String recipient : recipients) {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
        }
        MimeMultipart multipart = new MimeMultipart("related");
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setContent((Object)htmlBody, "text/html");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        message.setContent((Multipart)multipart);
        transport.connect();
        transport.sendMessage((Message)message, message.getRecipients(Message.RecipientType.TO));
        transport.close();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }
}

