/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils.snmp;

import java.util.ArrayList;
import java.util.List;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

class MOTableBuilder {
    private MOTableSubIndex[] subIndexes = new MOTableSubIndex[]{new MOTableSubIndex(2)};
    private MOTableIndex indexDef = new MOTableIndex(this.subIndexes, false);
    private final List<MOColumn> columns = new ArrayList<MOColumn>();
    private final List<Variable[]> tableRows = new ArrayList<Variable[]>();
    private int currentRow = 0;
    private int currentCol = 0;
    private OID tableRootOid;
    private int colTypeCnt = 0;

    MOTableBuilder(OID oid) {
        this.tableRootOid = oid;
    }

    public MOTableBuilder addColumnType(int syntax, MOAccess access) {
        ++this.colTypeCnt;
        this.columns.add(new MOColumn(this.colTypeCnt, syntax, access));
        return this;
    }

    public MOTableBuilder addRowValue(Variable variable) {
        if (this.tableRows.size() == this.currentRow) {
            this.tableRows.add(new Variable[this.columns.size()]);
        }
        this.tableRows.get((int)this.currentRow)[this.currentCol] = variable;
        ++this.currentCol;
        if (this.currentCol >= this.columns.size()) {
            ++this.currentRow;
            this.currentCol = 0;
        }
        return this;
    }

    public MOTable build() {
        DefaultMOTable ifTable = new DefaultMOTable(this.tableRootOid, this.indexDef, this.columns.toArray(new MOColumn[0]));
        MOMutableTableModel model = (MOMutableTableModel)ifTable.getModel();
        int i = 1;
        for (Variable[] variables : this.tableRows) {
            model.addRow((MOTableRow)new DefaultMOMutableRow2PC(new OID(String.valueOf(i)), variables));
            ++i;
        }
        ifTable.setVolatile(true);
        return ifTable;
    }
}

