/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils.snmp;

import com.activequant.utils.snmp.MOScalarFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.BaseAgent;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.transport.TransportMappings;

class SNMP4JFacade
extends BaseAgent {
    private static Logger log = Logger.getLogger(SNMP4JFacade.class);
    private String address = null;
    private HashMap<String, MOScalar> scalars = new HashMap();
    static final String baseOID = new String("");
    private Map<String, OID> oidMap = new HashMap<String, OID>();

    SNMP4JFacade(String address) throws IOException {
        super(new File("conf.agent"), new File("bootCounter.agent"), new CommandProcessor(new OctetString(MPv3.createLocalEngineID())));
        this.address = address;
        this.start();
    }

    public void registerOID(String key, String suffix) {
        String oidID = baseOID + suffix;
        log.info((Object)("Registering OID " + oidID));
        OID oid = new OID(oidID);
        this.oidMap.put(key, oid);
    }

    protected void addCommunities(SnmpCommunityMIB communityMIB) {
        Variable[] com2sec = new Variable[]{new OctetString("public"), new OctetString("cpublic"), this.getAgent().getContextEngineID(), new OctetString("public"), new OctetString(), new Integer32(3), new Integer32(1)};
        MOTableRow row = communityMIB.getSnmpCommunityEntry().createRow(new OctetString("public2public").toSubIndex(true), com2sec);
        communityMIB.getSnmpCommunityEntry().addRow(row);
    }

    protected void addNotificationTargets(SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
    }

    protected void addUsmUser(USM usm) {
    }

    protected void addViews(VacmMIB vacm) {
        vacm.addGroup(2, new OctetString("cpublic"), new OctetString("v1v2group"), 3);
        vacm.addAccess(new OctetString("v1v2group"), new OctetString("public"), 0, 1, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addViewTreeFamily(new OctetString("fullReadView"), new OID("1.3"), new OctetString(), 1, 3);
    }

    protected void initTransportMappings() throws IOException {
        TransportMapping tm;
        this.transportMappings = new TransportMapping[1];
        Address addr = GenericAddress.parse((String)this.address);
        this.transportMappings[0] = tm = TransportMappings.getInstance().createTransportMapping(addr);
    }

    public void registerManagedObject(ManagedObject mo, String oid) {
        try {
            this.server.register(mo, new OctetString("public"));
        }
        catch (DuplicateRegistrationException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void registerManagedObjects() {
    }

    public void setValue(String key, Integer value) throws Exception {
        MOScalar mo;
        if (!this.scalars.containsKey(key)) {
            if (!this.oidMap.containsKey(key)) {
                throw new Exception("OID for " + key + " not registered. ");
            }
            OID oid = this.oidMap.get(key);
            MOScalar mo2 = MOScalarFactory.createReadOnly(oid, key);
            this.scalars.put(key, mo2);
            this.registerManagedObject((ManagedObject)mo2, oid.toString());
        }
        if ((mo = this.scalars.get(key)) != null) {
            mo.setValue((Variable)new Integer32(value.intValue()));
        }
    }

    private void start() throws IOException {
        this.init();
        this.addShutdownHook();
        this.getServer().addContext(new OctetString("public"));
        this.finishInit();
        this.run();
        this.sendColdStartNotification();
        this.unregisterManagedObject((MOGroup)this.getSnmpv2MIB());
    }

    private void unregisterManagedObject(MOGroup moGroup) {
        moGroup.unregisterMOs((MOServer)this.server, this.getContext(moGroup));
    }

    protected void unregisterManagedObjects() {
    }
}

