/*
 * Decompiled with CFR 0.152.
 */
package com.activequant.utils.snmp;

import com.activequant.utils.snmp.SNMP4JFacade;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class SNMPReporter {
    private Logger log = Logger.getLogger(SNMPReporter.class);
    private SNMP4JFacade snmpFacade;
    private Map<String, Integer> valueMap = new ConcurrentHashMap<String, Integer>();
    private Map<String, ValueMode> modeMap = new ConcurrentHashMap<String, ValueMode>();

    public SNMPReporter(String host, int port) throws UnknownHostException, IOException {
        this.snmpFacade = new SNMP4JFacade("udp:" + host + "/" + port);
        TimerTask refDataDownloadTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    SNMPReporter.this.updateSNMPDirectory();
                }
                catch (Exception e) {
                    SNMPReporter.this.log.error((Object)"Error while updating SNMP directory", (Throwable)e);
                }
            }
        };
        long currentMs = System.currentTimeMillis();
        long delay = 60000L - currentMs % 60000L;
        Timer refDataDownloadTimer = new Timer(true);
        refDataDownloadTimer.scheduleAtFixedRate(refDataDownloadTask, 1L * delay, 60000L);
    }

    public SNMPReporter() throws UnknownHostException, IOException {
        this(InetAddress.getLocalHost().getHostAddress(), 65000);
    }

    public void registerOID(String key, String suffix, ValueMode valMode) {
        this.snmpFacade.registerOID(key, suffix);
        this.modeMap.put(key, valMode);
    }

    public void addValue(String key, Integer toBeAddedValue) {
        Integer val = 0;
        if (this.valueMap.containsKey(key)) {
            val = this.valueMap.get(key);
        }
        val = val + toBeAddedValue;
        this.setValue(key, val);
    }

    public void setValue(String key, Integer value) {
        this.valueMap.put(key, value);
    }

    private void updateSNMPDirectory() throws Exception {
        for (Map.Entry<String, Integer> entry : this.valueMap.entrySet()) {
            this.snmpFacade.setValue(entry.getKey(), entry.getValue());
            ValueMode valMode = this.modeMap.get(entry.getKey());
            if (!valMode.equals((Object)ValueMode.COUNTER)) continue;
            entry.setValue(0);
        }
    }

    public static void main(String[] args) throws Exception {
        SNMPReporter agent = new SNMPReporter();
        agent.registerOID("A", "1.3.6.1.1.0", ValueMode.VALUE);
        agent.registerOID("B", "1.3.6.1.2.0", ValueMode.VALUE);
        System.out.println("Done ....");
        while (true) {
            Thread.sleep(1000L);
            agent.setValue("A", (int)(Math.random() * 1000.0));
            agent.setValue("B", (int)(Math.random() * 1000.0));
        }
    }

    public static enum ValueMode {
        COUNTER,
        VALUE;

    }
}

