/*
 * Decompiled with CFR 0.152.
 */
package com.addc.server.commons.monitored;

import com.addc.server.AppContextHelper;
import com.addc.server.commons.ManagedObject;
import com.addc.server.commons.monitored.MonitoringClient;
import com.addc.server.commons.monitored.MonitoringClientFactory;
import com.addc.server.monitoring.MonitoredException;
import com.addc.server.monitoring.MonitoredPOA;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class MonitoredImpl
extends MonitoredPOA {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoredImpl.class);
    private MonitoringClient monitorThread;

    @Override
    public void ping() throws MonitoredException {
        ArrayList<String> errors = new ArrayList<String>();
        List<ManagedObject> components = this.getMonitoringClient().getMonitoredComponents();
        LinkedList<ManagedObject> lost = new LinkedList<ManagedObject>();
        for (ManagedObject mo : components) {
            try {
                if (!mo.getObjectRef()._non_existent()) continue;
                errors.add(mo.getCorbaloc() + " has been destroyed");
                lost.add(mo);
            }
            catch (SystemException e) {
                LOGGER.error("Unexpected CORBA Exception", (Throwable)e);
            }
        }
        if (!errors.isEmpty()) {
            LOGGER.warn("One or more managed Objects have been destroyed: {}", errors);
            for (ManagedObject mo : lost) {
                this.monitorThread.removeComponent(mo);
            }
            throw new MonitoredException(errors.toArray(new String[0]));
        }
    }

    @Override
    public String[] monitoredComponents() {
        return this.getMonitoringClient().getMonitoredComponentCorbalocs();
    }

    MonitoringClient getMonitoringClient() {
        if (this.monitorThread == null) {
            ApplicationContext context = AppContextHelper.getInstance().getAppContext();
            MonitoringClientFactory bean = (MonitoringClientFactory)context.getBean("orbWrapper", MonitoringClientFactory.class);
            this.monitorThread = bean.getMonitoringClient();
        }
        return this.monitorThread;
    }
}

