/*
 * Decompiled with CFR 0.152.
 */
package com.addc.server.commons.monitored;

import com.addc.commons.Mutex;
import com.addc.commons.alerts.Notifier;
import com.addc.commons.i18n.I18nTextFactory;
import com.addc.commons.iiop.OrbHolder;
import com.addc.commons.shutdown.Stoppable;
import com.addc.server.commons.ManagedObject;
import com.addc.server.commons.alerts.AlertFactory;
import com.addc.server.commons.monitored.MonitoringClientState;
import com.addc.server.monitoring.Monitor;
import com.addc.server.monitoring.MonitorHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringClient
extends TimerTask
implements Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringClient.class);
    private static final String I18N_NAME = "com.addc.server.Messages";
    private final Map<String, ManagedObject> monitoredComponents = new ConcurrentHashMap<String, ManagedObject>();
    private final ORB orb;
    private final Notifier notifier;
    private final Set<String> sourceIds;
    private final Mutex lock = new Mutex();
    private final int leaseTime;
    private Timer monitorTimer;
    private final MonitoringClientState state;
    private Monitor remoteMonitor;
    private String monitoredCobaloc;

    public MonitoringClient(Notifier notifier, int leaseTime, int failCount) {
        this.orb = OrbHolder.getInstance().getOrb();
        this.notifier = notifier;
        this.sourceIds = new HashSet<String>();
        this.sourceIds.add(this.getClass().getSimpleName());
        this.leaseTime = leaseTime;
        if (leaseTime > 0) {
            this.monitorTimer = new Timer(this.getClass().getSimpleName());
        }
        this.state = new MonitoringClientState(notifier, failCount);
    }

    public void setMonitoredCobaloc(String corbaloc) {
        LOGGER.info("Set the Monitored object to {}", (Object)corbaloc);
        this.monitoredCobaloc = corbaloc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponent(ManagedObject mo) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            if (!this.monitoredComponents.containsKey(mo.getCorbaloc())) {
                LOGGER.info("Add {} to check list", (Object)mo.getCorbaloc());
                this.monitoredComponents.put(mo.getCorbaloc(), mo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponent(ManagedObject mo) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            if (this.monitoredComponents.containsKey(mo.getCorbaloc())) {
                LOGGER.info("Remove {} from check list", (Object)mo.getCorbaloc());
                this.monitoredComponents.remove(mo.getCorbaloc());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMonitoredComponentCorbalocs() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            return new LinkedList<String>(this.monitoredComponents.keySet()).toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ManagedObject> getMonitoredComponents() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            return new LinkedList<ManagedObject>(this.monitoredComponents.values());
        }
    }

    @Override
    public void run() {
        if (!this.state.isShutdown()) {
            this.updateRefsToService();
        }
    }

    public void shutdown() {
        if (!this.state.isShutdown()) {
            this.state.setShutdown(true);
            this.monitorTimer.cancel();
            this.unregisterAll();
            this.monitoredComponents.clear();
        }
    }

    public void start() {
        if (this.leaseTime > 0) {
            this.monitorTimer.schedule((TimerTask)this, 1000L, (long)this.leaseTime * 950L);
        }
    }

    private void connect() {
        if (this.monitoredCobaloc != null && !this.state.isConnected()) {
            try {
                this.remoteMonitor = MonitorHelper.narrow(this.orb.resolve_initial_references("MonitoringService"));
                this.state.resetConnFailCounter();
                this.state.setConnected(true);
            }
            catch (Exception e) {
                this.state.incConnFailCounter(e);
            }
            if (!this.state.isRegistered() && this.state.isConnected()) {
                try {
                    this.remoteMonitor.componentStarts(this.monitoredCobaloc, this.leaseTime);
                    this.state.setRegistered(true);
                    LOGGER.info("Registered local Monitored with Amentet Monitoring Service");
                }
                catch (SystemException e) {
                    LOGGER.error("Failed to register with Amentet Monitoring Service", (Throwable)e);
                    this.notifier.notifyAlert(AlertFactory.getMonitorRegisterFailed(this.sourceIds, (String)e.getMessage()), I18nTextFactory.getTranslator((String)I18N_NAME));
                    this.state.setConnected(false);
                }
            }
        }
    }

    private void disconnect() {
        if (this.monitoredCobaloc != null && this.state.isConnected()) {
            if (this.state.isRegistered()) {
                try {
                    this.remoteMonitor.componentStops(this.monitoredCobaloc);
                    LOGGER.info("Disconnected Monitored from Amentet Monitoring Service");
                }
                catch (SystemException e) {
                    LOGGER.error("Failed to disconnect from Monitor", (Throwable)e);
                    this.notifier.notifyAlert(AlertFactory.getMonitorDisconnFailed(this.sourceIds, (String)e.getMessage()), I18nTextFactory.getTranslator((String)I18N_NAME));
                }
            }
            try {
                this.remoteMonitor._release();
            }
            catch (Exception e) {
                LOGGER.debug("", (Throwable)e);
            }
            this.state.setConnected(false);
            this.state.setRegistered(false);
        }
        this.remoteMonitor = null;
    }

    private void updateRefsToService() {
        this.connect();
        if (this.state.isConnected()) {
            this.checkComponents();
            try {
                this.remoteMonitor.componentRefresh(this.monitoredCobaloc);
            }
            catch (SystemException e) {
                LOGGER.error("Failed to refresh Monitor", (Throwable)e);
                this.notifier.notifyAlert(AlertFactory.getMonitorInvokeFailed(this.sourceIds, (String)e.getMessage()), I18nTextFactory.getTranslator((String)I18N_NAME));
                this.state.setConnected(false);
                this.state.setRegistered(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkComponents() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            LinkedList<String> lost = new LinkedList<String>();
            for (Map.Entry<String, ManagedObject> entry : this.monitoredComponents.entrySet()) {
                try {
                    if (!entry.getValue().getObjectRef()._non_existent()) continue;
                    LOGGER.warn(entry.getKey() + " has died.");
                    lost.add(entry.getKey());
                }
                catch (SystemException e) {
                    LOGGER.error("Unexpected CORBA Exception", (Throwable)e);
                }
            }
            for (String cloc : lost) {
                this.monitoredComponents.remove(cloc);
            }
        }
    }

    private void unregisterAll() {
        this.connect();
        if (this.remoteMonitor != null) {
            try {
                this.remoteMonitor.componentStops(this.monitoredCobaloc);
                this.state.setRegistered(false);
            }
            catch (SystemException e) {
                this.state.setConnected(false);
            }
            this.disconnect();
        }
    }
}

