/*
 * Decompiled with CFR 0.152.
 */
package com.addc.server.commons.monitored;

import com.addc.commons.Mutex;
import com.addc.commons.alerts.Notifier;
import com.addc.commons.i18n.I18nTextFactory;
import com.addc.server.commons.alerts.AlertFactory;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MonitoringClientState {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringClientState.class);
    private final Mutex lock = new Mutex();
    private boolean connected;
    private int connFailCounter;
    private boolean registered;
    private boolean shutdown;
    private boolean started;
    private final int failOnConnCount;
    private final Notifier notifier;
    private Set<String> sourceIds;

    public MonitoringClientState(Notifier notifier, int failOnConnCount) {
        this.failOnConnCount = failOnConnCount;
        this.notifier = notifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            return this.connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnected(boolean connected) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.connected = connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnFailCounter() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            return this.connFailCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnFailCounter() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.connFailCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incConnFailCounter(Exception e) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            ++this.connFailCounter;
            if (this.connFailCounter % this.failOnConnCount == 0) {
                LOGGER.error("Failed to connect to Monitor {} times", (Object)this.connFailCounter, (Object)e);
                this.notifier.notifyAlert(AlertFactory.getMonitorConnFailed(this.sourceIds), I18nTextFactory.getTranslator((String)"com.addc.server.Messages"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            return this.registered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegistered(boolean registered) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.registered = registered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShutdown() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShutdown(boolean shutdown) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.shutdown = shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            return this.started;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStarted(boolean started) {
        Mutex mutex = this.lock;
        synchronized (mutex) {
            this.started = started;
        }
    }
}

