package com.adgem.android;

import androidx.annotation.MainThread;

/**
 * General callback interface for AdGem clients. Use {@link AdGem#registerCallback(AdGemCallback)} to register.
 */
public interface AdGemCallback {
    /**
     * Notifies that an interstitial ad state was updated.
     */
    @MainThread
    default void onInterstitialAdStateChanged(@AdGem.State int newState) {
    }

    /**
     * Notifies that a rewarded ad state was updated.
     */
    @MainThread
    default void onRewardedAdStateChanged(@AdGem.State int newState) {
    }

    /**
     * Notifies that AdGem offer wall state was changed.
     *
     * @deprecated use {@link OfferWallCallback#onOfferWallStateChanged(int)} instead.
     */
    @MainThread
    @Deprecated
    default void onOfferWallStateChanged(@AdGem.State int newState) {
    }

    /**
     * Notifies to reward user for the action they performed in the offer wall.
     *
     * @see AdGem#showOfferWall(android.content.Context context)
     * @deprecated use {@link OfferWallCallback#onOfferWallReward(int)}
     */
    @MainThread
    @Deprecated
    default void onRewardUser(int amount) {
    }

    /**
     * Notifies that the interstitial ad was closed.
     *
     * @see AdGem#showInterstitialAd(android.content.Context context)
     */
    default void onInterstitialAdClosed() {
    }

    /**
     * Notifies that AdGem has successfully completed showing rewarded ad to the user.
     *
     * @see AdGem#showRewardedAd(android.content.Context context)
     */
    default void onRewardedAdComplete() {
    }

    /**
     * Notifies that the user has cancelled rewarded ad.
     *
     * @see AdGem#showRewardedAd(android.content.Context context)
     */
    default void onRewardedAdCancelled() {
    }
}
