package com.adgem.android;

/**
 * Callback to receive updates from AdGem Offer Wall. Use {@link AdGem#registerOfferWallCallback(OfferWallCallback)} to register.
 */
public interface OfferWallCallback {
    /**
     * Notifies that the offer wall state was changed.
     *
     * @see AdGem#showOfferWall(android.content.Context context)
     */
    default void onOfferWallStateChanged(@AdGem.State int newState) {
    }

    /**
     * Notifies to reward user for the action they performed in the offer wall.
     *
     * @see AdGem#showOfferWall(android.content.Context context)
     */
    default void onOfferWallReward(int amount) {
    }

    /**
     * Notifies that the offer wall has been closed.
     * it.
     *
     * @see AdGem#showOfferWall(android.content.Context context)
     */
    default void onOfferWallClosed() {
    }
}
