package com.adgem.android;

public final class Error {
    public final String message;
    public final Throwable cause;

    public static Error withMessage(String message) {
        return withMessage(message, null);
    }

    public static Error withMessage(String message, Throwable cause) {
        return new Error(message, cause);
    }

    private Error(String message, Throwable cause) {
        this.message = message;
        this.cause = cause;
    }
}
