package com.adgem.android;

import android.content.Context;

import androidx.annotation.MainThread;

import com.adgem.android.internal.RealGem;

/**
 * Main entry point for communications with AdGem SDK. Use {@link #get()} to acquire instance of this class.
 */
public abstract class AdGem {
    /**
     * Obtains global instance of the AdGem framework.
     */
    public static AdGem get() {
        return RealGem.get();
    }

    /**
     * Sets metadata specific to the user of this application. Required for AdGem to work properly.
     *
     * @param metaData information about the player.
     * @see PlayerMetadata.Builder for additional fields.
     */
    public abstract void setPlayerMetaData(PlayerMetadata metaData);

    /**
     * Registers callback to receive updates about the offer wall. Each registered callback will receive corresponding events.
     *
     * @param callback instance of callback to receive offer wall events from AdGem. All events will be delivered on a main
     *                 thread. Reference to this callback will be kept internally until unregistered via
     *                 {@link #unregisterOfferwallCallback(OfferwallCallback)}.
     * @see #unregisterOfferwallCallback(OfferwallCallback)
     */
    @MainThread
    public abstract void registerOfferwallCallback(OfferwallCallback callback);

    /**
     * Unregisters AdGem events callback.
     *
     * @param callback instance of {@link OfferwallCallback} previously registered via {@link #registerOfferwallCallback(OfferwallCallback)}.
     */
    @MainThread
    public abstract void unregisterOfferwallCallback(OfferwallCallback callback);

    /**
     * Shows offer wall. Offer wall status callbacks (including even when offer wall is closed) will be delivered via the {@link OfferwallCallback}.
     */
    public abstract void showOfferwall(Context context);
}
