/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.adgem.android.internal.Config;
import com.adgem.android.internal.RealGem;

public abstract class AdGemActivity
extends Activity {
    private static Typeface NUNITO_SANS_REGULAR;
    private static Typeface NUNITO_SANS_BOLD;

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Config.get((Context)this).lockOrientation) {
            switch (RealGem.get().getOrientation()) {
                case LANDSCAPE: {
                    this.setRequestedOrientation(6);
                    break;
                }
                case PORTRAIT: {
                    this.setRequestedOrientation(7);
                    break;
                }
                default: {
                    this.setRequestedOrientation(-1);
                }
            }
        }
    }

    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        View view = super.onCreateView(parent, name, context, attrs);
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            Typeface typeface = textView.getTypeface();
            if (typeface.isBold()) {
                textView.setTypeface(this.getNunitoSansBold());
            } else {
                textView.setTypeface(this.getNunitoSansRegular());
            }
        }
        return view;
    }

    private Typeface getNunitoSansRegular() {
        if (NUNITO_SANS_REGULAR == null) {
            NUNITO_SANS_REGULAR = Typeface.createFromAsset((AssetManager)this.getAssets(), (String)"nunito_sans_regular.ttf");
        }
        return NUNITO_SANS_REGULAR;
    }

    private Typeface getNunitoSansBold() {
        if (NUNITO_SANS_BOLD == null) {
            NUNITO_SANS_BOLD = Typeface.createFromAsset((AssetManager)this.getAssets(), (String)"nunito_sans_bold.ttf");
        }
        return NUNITO_SANS_BOLD;
    }
}

