/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.WorkerThread;
import java.io.File;

public final class Util {
    private Util() {
    }

    @Deprecated
    @WorkerThread
    static void deleteAllFilesIn(File directory) {
        File[] files;
        if (directory.exists() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                file.delete();
            }
        }
    }

    static void checkOnMainThreadOrThrow() {
        if (!Util.isOnMainThread()) {
            throw new IllegalStateException("Operation is not allowed on background thread.");
        }
    }

    public static void checkOnBackgroundThreadOrThrow() {
        if (Util.isOnMainThread()) {
            throw new IllegalStateException("Operation is not allowed on background thread.");
        }
    }

    public static boolean isOnMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    public static void runOnMainThread(Runnable runnable) {
        if (Util.isOnMainThread()) {
            runnable.run();
        } else {
            new Handler(Looper.getMainLooper()).post(runnable);
        }
    }

    public static void openBrowser(Activity parent, Uri uri) {
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.addFlags(0x10000000);
        parent.startActivity(intent);
    }

    public static void openPlayStore(Activity parent, String packageName) {
        Uri uri = Uri.parse((String)("https://play.google.com/store/apps/details?id=" + packageName));
        parent.startActivity(new Intent("android.intent.action.VIEW", uri));
    }
}

