/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal.transport;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.adgem.android.internal.LockFreeReference;
import java.util.ArrayList;
import java.util.List;

public final class Internet {
    private static final LockFreeReference<Internet, Context> INSTANCE = new LockFreeReference<Internet, Context>(Internet::new);
    private final Context mContext;
    private final List<ConnectivityCallback> mCallbacks = new ArrayList<ConnectivityCallback>();
    private final ConnectivityManager mConnectivityManager;
    private final ConnectivityChangeReceiver mConnectivityChangeReceiver = new ConnectivityChangeReceiver();

    private Internet(Context context) {
        this.mContext = context.getApplicationContext();
        this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
    }

    public static Internet get(Context context) {
        return INSTANCE.get(context);
    }

    public boolean isConnected() {
        NetworkInfo activeNetworkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public void addConnectivityCallback(ConnectivityCallback callback) {
        if (this.mCallbacks.isEmpty()) {
            this.mContext.registerReceiver((BroadcastReceiver)this.mConnectivityChangeReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        this.mCallbacks.add(callback);
    }

    public void removeConnectivityCallback(ConnectivityCallback callback) {
        if (this.mCallbacks.remove(callback) && this.mCallbacks.isEmpty()) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mConnectivityChangeReceiver);
        }
    }

    private final class ConnectivityChangeReceiver
    extends BroadcastReceiver {
        private ConnectivityChangeReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            if (networkInfo != null) {
                networkInfo = Internet.this.mConnectivityManager.getNetworkInfo(networkInfo.getType());
            }
            boolean connected = networkInfo != null && networkInfo.isConnected();
            for (ConnectivityCallback callback : Internet.this.mCallbacks) {
                if (connected) {
                    callback.onInternetConnected();
                    continue;
                }
                callback.onInternetDisconnected();
            }
        }
    }

    public static interface ConnectivityCallback {
        public void onInternetConnected();

        public void onInternetDisconnected();
    }
}

