/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal.transport;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.webkit.WebSettings;
import androidx.annotation.WorkerThread;
import com.adgem.android.internal.AdGemRuntime;
import com.adgem.android.internal.Config;
import com.adgem.android.internal.SessionIdProvider;
import com.adgem.android.internal.SingletonReference;
import com.adgem.android.internal.data.Data;
import com.adgem.android.internal.tracking.AdTracking;
import com.adgem.android.internal.transport.RetrofitService;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

public final class Transport {
    private final Context mContext;
    private final SessionIdProvider mSessionIdProvider;
    private final String mAdGemBaseUrl;
    private final AdTracking mAdTracking;
    private volatile RetrofitService mService;
    private volatile Map<String, String> mOptionalFields;
    private Interceptor mTrafficInterceptor;

    public Transport(Context context, SessionIdProvider sessionIdProvider, String adGemBaseUrl) {
        this.mContext = context.getApplicationContext();
        this.mSessionIdProvider = sessionIdProvider;
        this.mAdGemBaseUrl = adGemBaseUrl;
        this.mAdTracking = new AdTracking(context);
    }

    @WorkerThread
    public String getOfferwallUrl(String salt) {
        HttpUrl.Builder builder = HttpUrl.parse((String)this.mAdGemBaseUrl).newBuilder().addPathSegment("wall").setQueryParameter("salt", salt).setQueryParameter("location", "sdk");
        return this.appendAdGemQueryParams(builder).toString();
    }

    public synchronized void setOptionalFields(Map<String, String> fields) {
        this.mOptionalFields = new HashMap<String, String>(fields);
    }

    public synchronized void addOptionalFields(Map<String, String> fields) {
        if (this.mOptionalFields != null) {
            this.mOptionalFields.putAll(fields);
        } else {
            this.setOptionalFields(fields);
        }
    }

    public synchronized boolean hasOptionalField(String key) {
        if (this.mOptionalFields != null) {
            return this.mOptionalFields.containsKey(key);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetrofitService getRetrofitService() {
        if (this.mService == null) {
            Transport transport = this;
            synchronized (transport) {
                if (this.mService == null) {
                    OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder().readTimeout(30L, TimeUnit.SECONDS).addInterceptor(new Interceptor(){
                        final SingletonReference<String, Context> userAgent = new SingletonReference<String, Context>(WebSettings::getDefaultUserAgent);

                        public Response intercept(Interceptor.Chain chain) throws IOException {
                            Request originalRequest = chain.request();
                            HttpUrl originalUrl = originalRequest.url();
                            Request newRequest = originalUrl.toString().startsWith(Transport.this.mAdGemBaseUrl) ? originalRequest.newBuilder().url(Transport.this.appendAdGemQueryParams(originalUrl.newBuilder()).build()).header("User-Agent", this.userAgent.get(Transport.this.mContext)).build() : originalRequest;
                            return chain.proceed(newRequest);
                        }
                    }).addInterceptor(chain -> {
                        Interceptor externalInterceptor = this.mTrafficInterceptor;
                        if (externalInterceptor != null) {
                            return externalInterceptor.intercept(chain);
                        }
                        return chain.proceed(chain.request());
                    });
                    Retrofit retrofit = new Retrofit.Builder().baseUrl(this.mAdGemBaseUrl).addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)Data.jsonParser())).client(httpClientBuilder.build()).build();
                    this.mService = (RetrofitService)retrofit.create(RetrofitService.class);
                }
            }
        }
        return this.mService;
    }

    public String getBaseUrl() {
        return this.mAdGemBaseUrl;
    }

    public void followRedirects(String url) {
        this.mService.get(url).enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, retrofit2.Response<ResponseBody> response) {
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
            }
        });
    }

    public void setHttpInterceptor(Interceptor interceptor) {
        this.mTrafficInterceptor = interceptor;
    }

    @WorkerThread
    private HttpUrl.Builder appendAdGemQueryParams(HttpUrl.Builder builder) {
        Config config = Config.get(this.mContext);
        AdGemRuntime runtime = AdGemRuntime.get(this.mContext);
        boolean adTrackingEnabled = this.mAdTracking.isGoogleAdTrackingEnabled();
        if (adTrackingEnabled) {
            builder.setQueryParameter("gaid", this.mAdTracking.getGoogleAdvertisingId());
        }
        builder.setQueryParameter("ad_tracking_enabled", Boolean.toString(adTrackingEnabled));
        builder.setQueryParameter("appid", Integer.toString(config.applicationId)).setQueryParameter("platform", "Android").setQueryParameter("sdk_type", "Android").setQueryParameter("osversion", Build.VERSION.RELEASE).setQueryParameter("device", Build.MODEL).setQueryParameter("devicename", runtime.getDeviceId()).setQueryParameter("sdk_version", "4.0.3").setQueryParameter("pkg_id", runtime.packageName).setQueryParameter("pkg_rev", runtime.versionCode).setQueryParameter("app_version", runtime.versionName).setQueryParameter("display_w", Integer.toString(runtime.displayWidth)).setQueryParameter("display_h", Integer.toString(runtime.displayHeight)).setQueryParameter("display_d", Float.toString(runtime.displayDensity)).setQueryParameter("language_code", Locale.getDefault().getISO3Language()).setQueryParameter("timezone", runtime.getTimeZone()).setQueryParameter("carrier_name", runtime.getCarrierName()).setQueryParameter("app_session_id", this.mSessionIdProvider.getSessionId());
        Map<String, String> optionalFields = this.mOptionalFields;
        if (optionalFields != null) {
            if (config.debuggable) {
                Log.i((String)"AdGem", (String)("Sending extra fields: " + optionalFields));
            }
            for (Map.Entry<String, String> field : optionalFields.entrySet()) {
                builder.setQueryParameter(field.getKey(), field.getValue());
            }
        }
        return builder;
    }
}

