package com.adgem.android;

/**
 * Callback to receive updates from AdGem Offer Wall. Use {@link AdGem#registerOfferwallCallback(OfferwallCallback)} to register.
 */
public interface OfferwallCallback {
    /**
     * Notifies that the offer wall loading has started.
     *
     * @see AdGem#showOfferwall(android.content.Context context)
     */
    default void onOfferwallLoadingStarted() {
    }

    /**
     * Notifies that the offer wall has been loaded.
     *
     * @see AdGem#showOfferwall(android.content.Context context)
     */
    default void onOfferwallLoadingFinished() {
    }

    /**
     * Notifies that the offer wall has failed to load.
     *
     * @see AdGem#showOfferwall(android.content.Context context)
     */
    default void onOfferwallLoadingFailed(String error) {
    }

    /**
     * Notifies to reward user for the action they performed in the offer wall.
     *
     * @see AdGem#showOfferwall(android.content.Context context)
     */
    default void onOfferwallRewardReceived(int amount) {
    }

    /**
     * Notifies that the offer wall has been closed.
     *
     * @see AdGem#showOfferwall(android.content.Context context)
     */
    default void onOfferwallClosed() {
    }
}
