/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class PlayerMetadata {
    public final Map<String, String> entries;

    private PlayerMetadata(Map<String, String> entries) {
        this.entries = Collections.unmodifiableMap(entries);
    }

    public static final class Builder {
        private static final int MAX_LENGTH = 65535;
        private final Map<String, String> mEntries = new HashMap<String, String>();

        private Builder(String playerId) {
            this.id(playerId);
        }

        public static Builder createWithPlayerId(String playerId) {
            return new Builder(playerId);
        }

        @NonNull
        public Builder id(@NonNull String playerId) {
            if (playerId == null) {
                throw new IllegalArgumentException("Player ID can not be null");
            }
            if (playerId.length() > 65535) {
                throw new IllegalArgumentException("Player ID can not be more than 65535 characters");
            }
            this.mEntries.put("player_id", playerId);
            this.mEntries.put("playerid", playerId);
            return this;
        }

        @NonNull
        public Builder age(@IntRange(from=0L, to=99L) int age) {
            if (age < 0 || age > 99) {
                throw new IllegalArgumentException("Age must be between 0 and 99");
            }
            this.mEntries.put("player_age", Integer.toString(age));
            return this;
        }

        @NonNull
        public Builder gender(@NonNull Gender gender) {
            if (gender == null) {
                throw new IllegalArgumentException("Gender can not be null");
            }
            switch (gender) {
                case MALE: {
                    this.mEntries.put("player_gender", "male");
                    break;
                }
                case FEMALE: {
                    this.mEntries.put("player_gender", "female");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown gender");
                }
            }
            return this;
        }

        @NonNull
        public Builder level(@IntRange(from=0L, to=1000000000L) int level) {
            if (level < 0 || level > 1000000000) {
                throw new IllegalArgumentException("Level must be between 0 and 1,000,000,000");
            }
            this.mEntries.put("player_level", Integer.toString(level));
            return this;
        }

        @NonNull
        public Builder placement(long rank) {
            if (rank < 0L || rank > 1000000000L) {
                throw new IllegalArgumentException("Rank must be between 0 and 1,000,000,000");
            }
            this.mEntries.put("placement", Long.toString(rank));
            return this;
        }

        @NonNull
        public Builder isPayer(boolean payer) {
            this.mEntries.put("player_payer", Boolean.toString(payer));
            return this;
        }

        @NonNull
        public Builder iapTotalUsd(float value) {
            if (value < 0.0f || value > 99999.99f) {
                throw new IllegalArgumentException("Value should be in a range between 0 and 99999.99");
            }
            this.mEntries.put("player_iap_total_usd", Float.toString(value));
            return this;
        }

        @NonNull
        public Builder createdAt(@NonNull String timestamp) {
            if (timestamp == null) {
                throw new IllegalArgumentException("Timestamp can not be null");
            }
            this.mEntries.put("player_created_at", timestamp);
            return this;
        }

        public Builder customFields(String ... fields) {
            if (fields == null) {
                throw new IllegalArgumentException("Fields can not be null");
            }
            if (fields.length > 0) {
                for (int i = 1; i <= 5 && i <= fields.length; ++i) {
                    String field = fields[i - 1];
                    if (field == null) {
                        throw new IllegalArgumentException("Field on position " + i + " can not be null");
                    }
                    if (field.length() > 99) {
                        throw new IllegalArgumentException("Field on position " + i + " can not be over 99 characters");
                    }
                    this.mEntries.put("c" + Integer.toString(i), fields[i - 1]);
                }
            }
            return this;
        }

        @NonNull
        public Builder customField1(@NonNull String field) {
            return this.customField(field, 1);
        }

        @NonNull
        public Builder customField2(@NonNull String field) {
            return this.customField(field, 2);
        }

        @NonNull
        public Builder customField3(@NonNull String field) {
            return this.customField(field, 3);
        }

        @NonNull
        public Builder customField4(@NonNull String field) {
            return this.customField(field, 4);
        }

        @NonNull
        public Builder customField5(@NonNull String field) {
            return this.customField(field, 5);
        }

        private Builder customField(String field, int i) {
            if (i < 1 || i > 5) {
                throw new IllegalArgumentException("Field index should be in a range between 1 and 5");
            }
            if (field == null) {
                throw new IllegalArgumentException("Field c" + i + " can not be null");
            }
            if (field.length() > 99) {
                throw new IllegalArgumentException("Field c" + i + " can not be over 99 characters");
            }
            this.mEntries.put("c" + Integer.toString(i), field);
            return this;
        }

        @NonNull
        public PlayerMetadata build() {
            return new PlayerMetadata(this.mEntries);
        }
    }

    public static enum Gender {
        MALE,
        FEMALE;

    }
}

