/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.adgem.android.internal.LockFreeReference;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;

public final class AdGemRuntime {
    private static final LockFreeReference<AdGemRuntime, Context> INSTANCE = new LockFreeReference<AdGemRuntime, Context>(AdGemRuntime::new);
    private final Context mContext;
    public final String packageName;
    public final String versionCode;
    public final String versionName;
    public final String deviceId;
    public final int displayWidth;
    public final int displayHeight;
    public final float displayDensity;

    @SuppressLint(value={"HardwareIds"})
    private AdGemRuntime(Context context) {
        PackageInfo pi;
        this.mContext = context;
        PackageManager pm = context.getPackageManager();
        this.packageName = context.getPackageName();
        try {
            pi = pm.getPackageInfo(this.packageName, 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            pi = null;
            Log.e((String)"AdGem", (String)"Could not retrieve package into. Is package manager running?");
        }
        if (pi != null) {
            this.versionCode = Integer.toString(pi.versionCode);
            this.versionName = pi.versionName;
        } else {
            this.versionName = "Not found";
            this.versionCode = "Not found";
        }
        this.deviceId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        Display display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        this.displayDensity = metrics.densityDpi;
        Point size = new Point();
        display.getSize(size);
        this.displayWidth = size.x;
        this.displayHeight = size.y;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getCarrierName() {
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        return telephonyManager.getNetworkOperatorName();
    }

    public String getTimeZone() {
        if (Build.VERSION.SDK_INT >= 24) {
            return android.icu.util.TimeZone.getDefault().getID();
        }
        return TimeZone.getDefault().getID();
    }

    public String getLanguageCode() {
        return Locale.getDefault().toLanguageTag();
    }

    public String getCurrencyCode() {
        return Currency.getInstance(Locale.getDefault()).getCurrencyCode();
    }

    public String getOrientation(Context context) {
        int orientation = context.getResources().getConfiguration().orientation;
        if (orientation == 1) {
            return "portrait";
        }
        if (orientation == 2) {
            return "landscape";
        }
        return "unknown";
    }

    public String getDeviceName(Context context) {
        if (Build.VERSION.SDK_INT >= 25) {
            return Settings.Global.getString((ContentResolver)context.getContentResolver(), (String)"device_name");
        }
        return Build.MODEL;
    }

    @NonNull
    public static AdGemRuntime get(Context context) {
        return INSTANCE.get(context);
    }
}

