/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import com.adgem.android.internal.LockFreeReference;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public final class Config {
    private static final String CONFIG_XML_KEY = "com.adgem.Config";
    private static final LockFreeReference<Config, Context> INSTANCE = new LockFreeReference<Config, Context>(Config::create);
    public final int applicationId;
    public final boolean offerwallEnabled;
    final boolean lockOrientation;
    public final boolean debuggable;

    private Config(int applicationId, boolean offerwallEnabled, boolean lockOrientation, boolean debuggable) {
        this.applicationId = applicationId;
        this.offerwallEnabled = offerwallEnabled;
        this.lockOrientation = lockOrientation;
        this.debuggable = debuggable;
    }

    @NonNull
    public static Config get(Context context) {
        return INSTANCE.get(context);
    }

    private static Config create(Context context) {
        Config config;
        int configXmlResId = 0;
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            if (bundle != null && bundle.containsKey(CONFIG_XML_KEY)) {
                Object o = bundle.get(CONFIG_XML_KEY);
                if (o instanceof Integer) {
                    configXmlResId = (Integer)o;
                } else {
                    Log.e((String)"AdGem", (String)("Invalid AdGem config reference \"" + o + "\"."));
                }
            } else {
                Log.e((String)"AdGem", (String)"AdGem SDK config was not found. Make sure it is specified in the AndroidManifest.xml by adding\n<meta-data android:name=\"com.adgem.Config\"\n           android:resource=\"@xml/adgem_config\"\n/>in the <application> tag.");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"AdGem", (String)"Could not configure SDK", (Throwable)e);
        }
        if (configXmlResId > 0) {
            try {
                config = Config.parse(context, context.getResources().getXml(configXmlResId));
            }
            catch (IOException | XmlPullParserException e) {
                Log.e((String)"AdGem", (String)"Could not configure SDK", (Throwable)e);
                e.printStackTrace();
                config = Config.createUnknown();
            }
        } else {
            config = Config.createUnknown();
        }
        return config;
    }

    private static Config createUnknown() {
        return new Config(0, false, false, false);
    }

    private static Config parse(Context context, XmlResourceParser xml) throws IOException, XmlPullParserException {
        xml.next();
        xml.require(0, null, null);
        xml.next();
        xml.require(2, null, "adgem-configuration");
        int applicationId = xml.getAttributeIntValue(null, "applicationId", 0);
        boolean offerwallEnabled = xml.getAttributeBooleanValue(null, "offerwallEnabled", false);
        boolean lockOrientation = xml.getAttributeBooleanValue(null, "lockOrientation", false);
        boolean debuggable = xml.getAttributeBooleanValue(null, "debuggable", false);
        return new Config(applicationId, offerwallEnabled, lockOrientation, debuggable);
    }
}

