/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.util.Log;
import androidx.annotation.Nullable;
import com.adgem.android.AdGem;
import com.adgem.android.Error;
import com.adgem.android.OfferwallCallback;
import com.adgem.android.PlayerMetadata;
import com.adgem.android.internal.SessionTracker;
import com.adgem.android.internal.data.Orientation;
import com.adgem.android.internal.data.SessionStartAction;
import com.adgem.android.internal.offerwall.Offerwall;
import com.adgem.android.internal.offerwall.OfferwallActivity;
import com.adgem.android.internal.transport.AdGemResponse;
import com.adgem.android.internal.transport.Transport;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.Interceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public final class RealGem
extends AdGem
implements SessionTracker.SessionCallback {
    public static final String LOG_TAG = "AdGem";
    public static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();
    public static final int STATE_ERROR = -2;
    public static final int STATE_DISABLED = -1;
    public static final int STATE_NEEDS_INITIALIZATION = 0;
    public static final int STATE_INITIALIZING = 1;
    public static final int STATE_NEEDS_CAMPAIGN_REFRESH = 2;
    public static final int STATE_REFRESHING_CAMPAIGN = 3;
    public static final int STATE_NEEDS_DOWNLOAD = 4;
    public static final int STATE_DOWNLOADING = 5;
    public static final int STATE_READY = 6;
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile RealGem INSTANCE;
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context sApplicationContext;
    private final List<Call<?>> mInFlightNetworkCalls = new ArrayList(2);
    private Transport mTransport;
    private Offerwall mOfferwall;
    private SessionTracker mSessionTracker;
    private Error mError;
    private Orientation mOrientation = Orientation.AUTO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealGem get() {
        if (INSTANCE != null) return INSTANCE;
        Class<RealGem> clazz = RealGem.class;
        synchronized (RealGem.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new RealGem();
            if (sApplicationContext == null) return INSTANCE;
            INSTANCE.init(sApplicationContext, "https://api.adgem.com/v1/");
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    static void setApplicationContext(Context context) {
        if (context != null) {
            sApplicationContext = context.getApplicationContext();
        }
    }

    @Override
    public void setPlayerMetaData(PlayerMetadata metaData) {
        this.mTransport.setOptionalFields(metaData.entries);
        this.onSessionStart();
    }

    @Override
    public void registerOfferwallCallback(OfferwallCallback callback) {
        this.mOfferwall.addCallback(callback);
    }

    @Override
    public void unregisterOfferwallCallback(OfferwallCallback callback) {
        if (!this.mOfferwall.removeCallback(callback)) {
            RealGem.logError("Could not unregister callback " + callback);
        }
    }

    @Override
    public void showOfferwall(Context context) {
        if (!this.isPlayerIdSet()) {
            RealGem.logError("AdGem is not ready to show offer wall since Player ID is missing");
            return;
        }
        if (this.mOfferwall.isReady()) {
            OfferwallActivity.start(context);
        } else {
            RealGem.logError("AdGem is not ready to show offer wall");
        }
    }

    public Orientation getOrientation() {
        return this.mOrientation;
    }

    @Override
    public void onSessionStart() {
        if (this.isPlayerIdSet()) {
            this.performNetworkCall(this.mTransport.getRetrofitService().trackSession(), new Callback<AdGemResponse<SessionStartAction>>(){

                public void onResponse(Call<AdGemResponse<SessionStartAction>> call, Response<AdGemResponse<SessionStartAction>> response) {
                    AdGemResponse adGemResponse;
                    AdGemResponse adGemResponse2 = adGemResponse = response.isSuccessful() ? (AdGemResponse)response.body() : null;
                    if (adGemResponse != null) {
                        SessionStartAction sessionStartAction = (SessionStartAction)adGemResponse.data;
                        RealGem.this.mOrientation = sessionStartAction.orientation;
                        if (sessionStartAction.offerwallBackground != null) {
                            int color;
                            try {
                                color = Color.parseColor((String)('#' + sessionStartAction.offerwallBackground));
                            }
                            catch (IllegalArgumentException e) {
                                color = -1;
                            }
                            RealGem.this.mOfferwall.setBackgroundColor(color);
                        }
                        if (sessionStartAction.enableOfferwallPolling != null) {
                            RealGem.this.mOfferwall.setOfferCompletionPollingEnabled(sessionStartAction.enableOfferwallPolling != 0);
                        }
                    }
                }

                public void onFailure(Call<AdGemResponse<SessionStartAction>> call, Throwable t) {
                }
            });
        }
    }

    @Override
    public void onSessionEnd() {
        this.cancelPendingNetworkCalls();
    }

    public boolean isPlayerIdSet() {
        return this.mTransport.hasOptionalField("player_id");
    }

    public static void logError(String message) {
        Log.e((String)LOG_TAG, (String)message);
    }

    public static void logError(String message, Throwable e) {
        Log.e((String)LOG_TAG, (String)message, (Throwable)e);
    }

    public Offerwall getOfferWall() {
        return this.mOfferwall;
    }

    public void init(Context context, String baseUrl) {
        this.cancelPendingNetworkCalls();
        sApplicationContext = context = context.getApplicationContext();
        if (this.mSessionTracker == null) {
            this.mSessionTracker = new SessionTracker();
            this.mSessionTracker.addCallback(this);
            this.mSessionTracker.startTracking(context);
        }
        this.mTransport = new Transport(context, this.mSessionTracker, baseUrl);
        Offerwall newOfferwall = new Offerwall(context, this.mTransport);
        if (this.mOfferwall != null) {
            this.mSessionTracker.removeCallback(this.mOfferwall);
            this.mOfferwall.transferTo(newOfferwall);
        } else {
            newOfferwall.addCallback(new OfferwallCallback(){

                @Override
                public void onOfferwallLoadingFailed(String error) {
                    RealGem.this.mError = RealGem.this.mOfferwall.getError();
                }
            });
        }
        this.mOfferwall = newOfferwall;
        this.mSessionTracker.addCallback(this.mOfferwall);
        this.mError = null;
        if (this.mSessionTracker.isSessionActive()) {
            this.mOfferwall.onSessionStart();
        }
    }

    public String getBaseUrl() {
        return this.mTransport.getBaseUrl();
    }

    public void setHttpInterceptor(Interceptor interceptor) {
        this.mTransport.setHttpInterceptor(interceptor);
    }

    private <T> void performNetworkCall(Call<T> call) {
        this.performNetworkCall(call, null);
    }

    private void cancelPendingNetworkCalls() {
        for (Call<?> call : this.mInFlightNetworkCalls) {
            call.cancel();
        }
        this.mInFlightNetworkCalls.clear();
    }

    private <T> void performNetworkCall(Call<T> call, final @Nullable Callback<T> callback) {
        this.mInFlightNetworkCalls.add(call);
        call.enqueue(new Callback<T>(){

            public void onResponse(Call<T> call, Response<T> response) {
                RealGem.this.mInFlightNetworkCalls.remove(call);
                if (callback != null) {
                    callback.onResponse(call, response);
                }
            }

            public void onFailure(Call<T> call, Throwable t) {
                RealGem.this.mInFlightNetworkCalls.remove(call);
                if (callback != null) {
                    callback.onFailure(call, t);
                }
            }
        });
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

