/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import com.adgem.android.internal.SessionIdProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class SessionTracker
implements SessionIdProvider {
    private final List<SessionCallback> mSessionCallbacks = new ArrayList<SessionCallback>(3);
    private boolean mInBackground = true;
    private String mSessionId = UUID.randomUUID().toString();

    public boolean isSessionActive() {
        return !this.mInBackground;
    }

    @Override
    @NonNull
    public String getSessionId() {
        return this.mSessionId;
    }

    public void addCallback(SessionCallback callback) {
        this.mSessionCallbacks.add(callback);
    }

    public void removeCallback(SessionCallback callback) {
        this.mSessionCallbacks.remove(callback);
    }

    public void startTracking(Context context) {
        Application application = (Application)context.getApplicationContext();
        application.registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

            public void onConfigurationChanged(Configuration newConfig) {
            }

            public void onLowMemory() {
            }

            public void onTrimMemory(int level) {
                if (level == 20 && !SessionTracker.this.mInBackground) {
                    SessionTracker.this.mInBackground = true;
                    SessionTracker.this.onSessionEnded();
                }
            }
        });
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                if (SessionTracker.this.mInBackground) {
                    SessionTracker.this.mInBackground = false;
                    SessionTracker.this.onSessionStarted();
                }
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        });
    }

    private void onSessionStarted() {
        this.mSessionId = UUID.randomUUID().toString();
        for (SessionCallback callback : this.mSessionCallbacks) {
            callback.onSessionStart();
        }
    }

    private void onSessionEnded() {
        for (SessionCallback callback : this.mSessionCallbacks) {
            callback.onSessionEnd();
        }
    }

    public static interface SessionCallback {
        @MainThread
        public void onSessionStart();

        @MainThread
        public void onSessionEnd();
    }
}

