/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal.data;

import android.net.Uri;
import com.adgem.android.internal.RealGem;
import com.adgem.android.internal.data.Data;
import com.squareup.moshi.Json;
import java.io.IOException;
import java.util.Objects;
import okio.ByteString;

public class AdGemAction {
    @Json(name="action")
    public final String action;

    public AdGemAction() {
        this.action = null;
    }

    public static AdGemAction parse(String data) {
        AdGemAction adGemAction;
        String encodedBase64 = Uri.decode((String)data);
        String decodedJson = Objects.requireNonNull(ByteString.decodeBase64((String)encodedBase64)).utf8();
        try {
            adGemAction = (AdGemAction)Data.jsonParser().adapter(AdGemAction.class).fromJson(decodedJson);
        }
        catch (IOException e) {
            adGemAction = null;
            RealGem.logError("Unable to parse " + encodedBase64, e);
        }
        catch (RuntimeException e) {
            adGemAction = null;
            RealGem.logError("Unable to parse " + encodedBase64, e);
        }
        return adGemAction;
    }

    public static final class OpenBrowserGemAction
    extends AdGemAction {
        @Json(name="url")
        public final String url;

        public OpenBrowserGemAction() {
            this.url = null;
        }
    }

    public static final class OpenPlayStoreGemAction
    extends AdGemAction {
        @Json(name="url")
        public final String url;
        @Json(name="store_id")
        public final String appId;

        public OpenPlayStoreGemAction() {
            this.url = null;
            this.appId = null;
        }
    }

    public static final class Reward
    extends AdGemAction {
        @Json(name="completed")
        public final Boolean completed = true;
        @Json(name="user")
        public final String user;
        @Json(name="campaign")
        public final Long campaignId = 0L;
        @Json(name="amount")
        public final Integer amount = 0;
        @Json(name="signature")
        public final String signature;

        public Reward() {
            this.user = null;
            this.signature = null;
        }
    }
}

