/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal.data;

import android.util.Base64;
import androidx.annotation.MainThread;
import com.adgem.android.AdGemConfigurationException;
import com.adgem.android.internal.RealGem;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public final class MessageVerifier {
    private static final String key = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCb0kDNo34HMobS+mH1epdLFO95\n1EhX5RUEJ9+7ZEjiJHnRHVCWtXkbcKMOYhHflMhkHDw1xTIQSelrbAaAOVbnhZ+5\nEFvBCwl2NMTtu/wq1dgDWZSbid4hystLo0f2fSLJKCxpt151erkR+eWBSvaL8H3F\njose1UW71VxQ99uLJwIDAQAB";
    private final Signature mSignature;

    public MessageVerifier() {
        Signature signature;
        byte[] decodedKey = Base64.decode((String)key, (int)0);
        try {
            signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decodedKey)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AdGemConfigurationException("SHA1 algorithm not found", e);
        }
        catch (InvalidKeyException | InvalidKeySpecException e) {
            RealGem.logError("Invalid key configuration!", e);
            signature = null;
        }
        this.mSignature = signature;
    }

    @MainThread
    public boolean verify(String data, String sig) {
        boolean valid;
        boolean bl = valid = this.mSignature != null;
        if (valid) {
            try {
                this.mSignature.update(data.getBytes());
            }
            catch (SignatureException e) {
                RealGem.logError("Could not verify signature", e);
                valid = false;
            }
            if (valid) {
                try {
                    valid = this.mSignature.verify(Base64.decode((String)sig, (int)0));
                }
                catch (SignatureException e) {
                    valid = false;
                    RealGem.logError("Could not verify signature", e);
                }
            }
        }
        return valid;
    }
}

