/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal.offerwall;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.adgem.android.internal.RealGem;
import com.adgem.android.internal.data.AdGemAction;
import com.adgem.android.internal.data.MessageVerifier;
import com.adgem.android.internal.transport.AdGemResponse;
import com.adgem.android.internal.transport.Transport;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import retrofit2.Call;
import retrofit2.Response;

final class OfferCompletionChecker {
    private final Transport mTransport;
    private final String mSalt;
    private final Callback mCallback;
    private final Set<String> mUsedRewardSignatures = new HashSet<String>();
    private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
    private MessageVerifier mMessageVerifier;
    private long mLastClosedTimestamp;
    private boolean mOfferwallOpen;
    private boolean mOfferClicked;
    private boolean mPolingEnabled;

    OfferCompletionChecker(Transport transport, String salt, Callback callback) {
        this.mTransport = transport;
        this.mSalt = salt;
        this.mCallback = callback;
    }

    void onOfferwallOpened() {
        this.mOfferwallOpen = true;
        this.mOfferClicked = false;
        this.checkOfferCompletion();
    }

    void onOfferwallClosed() {
        this.mOfferwallOpen = false;
        this.mLastClosedTimestamp = System.currentTimeMillis();
        this.scheduleNextCheck();
    }

    void onOfferClick() {
        this.mOfferClicked = true;
        this.scheduleNextCheck();
    }

    void setPollingEnabled(boolean enabled) {
        this.mPolingEnabled = enabled;
        this.scheduleNextCheck();
    }

    void consumeReward(AdGemAction.Reward reward) {
        if (!this.mUsedRewardSignatures.contains(reward.signature)) {
            String message;
            this.mUsedRewardSignatures.add(reward.signature);
            if (this.mMessageVerifier == null) {
                this.mMessageVerifier = new MessageVerifier();
            }
            if (this.mMessageVerifier.verify(message = reward.user + Long.toString(reward.campaignId) + Integer.toString(reward.amount) + this.mSalt, reward.signature)) {
                this.mCallback.onRewardAck(reward.amount);
            } else {
                RealGem.logError("Attempt to use invalid reward was blocked!");
            }
        } else {
            RealGem.logError("Reward " + reward.signature + " was already used");
        }
    }

    private void checkOfferCompletion() {
        this.mMainThreadHandler.removeCallbacksAndMessages(null);
        this.mTransport.getRetrofitService().checkOfferwallCompletion(this.mSalt).enqueue((retrofit2.Callback)new retrofit2.Callback<AdGemResponse<AdGemAction.Reward>>(){

            public void onResponse(Call<AdGemResponse<AdGemAction.Reward>> call, Response<AdGemResponse<AdGemAction.Reward>> response) {
                AdGemResponse body = (AdGemResponse)response.body();
                if (body != null && "success".equals(body.status)) {
                    AdGemAction.Reward reward = (AdGemAction.Reward)body.data;
                    if (reward.completed.booleanValue() && reward.amount > 0 && !TextUtils.isEmpty((CharSequence)reward.signature)) {
                        OfferCompletionChecker.this.consumeReward(reward);
                    }
                }
                OfferCompletionChecker.this.scheduleNextCheck();
            }

            public void onFailure(Call<AdGemResponse<AdGemAction.Reward>> call, Throwable t) {
                OfferCompletionChecker.this.scheduleNextCheck();
            }
        });
    }

    private void scheduleNextCheck() {
        this.mMainThreadHandler.removeCallbacksAndMessages(null);
        if (this.mPolingEnabled) {
            if (this.mOfferwallOpen && this.mOfferClicked) {
                this.mMainThreadHandler.postDelayed(this::checkOfferCompletion, TimeUnit.SECONDS.toMillis(20L));
            } else if (this.mOfferClicked && System.currentTimeMillis() - this.mLastClosedTimestamp < TimeUnit.MINUTES.toMillis(5L)) {
                this.mMainThreadHandler.postDelayed(this::checkOfferCompletion, TimeUnit.SECONDS.toMillis(60L));
            }
        }
    }

    public static interface Callback {
        public void onRewardAck(int var1);
    }
}

