/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal.offerwall;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.AnyThread;
import androidx.annotation.ColorInt;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.adgem.android.Error;
import com.adgem.android.OfferwallCallback;
import com.adgem.android.internal.Config;
import com.adgem.android.internal.RealGem;
import com.adgem.android.internal.SessionTracker;
import com.adgem.android.internal.Util;
import com.adgem.android.internal.data.AdGemAction;
import com.adgem.android.internal.offerwall.OfferCompletionChecker;
import com.adgem.android.internal.transport.Internet;
import com.adgem.android.internal.transport.Transport;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public final class Offerwall
implements SessionTracker.SessionCallback,
Internet.ConnectivityCallback {
    private final Context mContext;
    private final Transport mTransport;
    private final Internet mInternet;
    private final OfferCompletionChecker mOfferChecker;
    private final String mSalt;
    private final List<OfferwallCallback> mCallbacks = new CopyOnWriteArrayList<OfferwallCallback>();
    @ColorInt
    private int mBackground;
    private int mState = 0;
    private OfferwallPresenter mOwner;
    private Call<Void> mOngoingLogOfferwallCall;
    private Error mError;

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public Offerwall(Context context, Transport transport) {
        this.mContext = context.getApplicationContext();
        this.mTransport = transport;
        this.mInternet = Internet.get(context);
        this.mSalt = Offerwall.generateSalt();
        this.mOfferChecker = new OfferCompletionChecker(transport, this.mSalt, this::notifyRewardReceived);
    }

    @MainThread
    @NonNull
    WebView open(OfferwallPresenter owner) {
        if (this.mOwner == null) {
            this.mOfferChecker.onOfferwallOpened();
            if (this.mOngoingLogOfferwallCall != null) {
                this.mOngoingLogOfferwallCall.cancel();
                this.mOngoingLogOfferwallCall = null;
            }
            this.mOngoingLogOfferwallCall = this.mTransport.getRetrofitService().trackOfferwallOpen();
            this.mOngoingLogOfferwallCall.enqueue((Callback)new Callback<Void>(){

                public void onResponse(@NonNull Call<Void> call, @NonNull Response<Void> response) {
                    Offerwall.this.mOngoingLogOfferwallCall = null;
                }

                public void onFailure(@NonNull Call<Void> call, @NonNull Throwable t) {
                    Offerwall.this.mOngoingLogOfferwallCall = null;
                }
            });
        }
        this.mOwner = owner;
        return this.onCreateWebView();
    }

    public void transferTo(Offerwall newOfferwall) {
        for (OfferwallCallback callback : this.mCallbacks) {
            newOfferwall.addCallback(callback);
        }
        this.mCallbacks.clear();
        if (this.mOngoingLogOfferwallCall != null) {
            this.mOngoingLogOfferwallCall.cancel();
            this.mOngoingLogOfferwallCall = null;
        }
    }

    @MainThread
    void close(OfferwallPresenter owner) {
        if (this.mOwner == owner) {
            this.mOwner = null;
            this.mOfferChecker.onOfferwallClosed();
            this.notifyClosed();
            this.refreshState(true);
        }
    }

    public void setBackgroundColor(@ColorInt int color) {
        this.mBackground = color;
    }

    public void addCallback(OfferwallCallback callback) {
        this.mCallbacks.add(callback);
    }

    public boolean removeCallback(OfferwallCallback callback) {
        return this.mCallbacks.remove(callback);
    }

    public void setOfferCompletionPollingEnabled(boolean pollingEnabled) {
        this.mOfferChecker.setPollingEnabled(pollingEnabled);
    }

    public int getState() {
        return this.mState;
    }

    public boolean isReady() {
        return this.mState == 6;
    }

    public Error getError() {
        return this.mError;
    }

    @Override
    @MainThread
    public void onSessionStart() {
        if (this.mState == 0) {
            this.setState(1);
            RealGem.THREAD_POOL.submit(() -> {
                if (Config.get((Context)this.mContext).offerwallEnabled) {
                    this.refreshState(true);
                } else {
                    this.setState(-1);
                    this.close(this.mOwner);
                }
            });
        } else {
            this.refreshState(false);
        }
        this.mInternet.addConnectivityCallback(this);
    }

    @Override
    public void onSessionEnd() {
        this.mInternet.removeConnectivityCallback(this);
    }

    @Override
    public void onInternetConnected() {
        this.refreshState(false);
    }

    @Override
    public void onInternetDisconnected() {
        this.refreshState(false);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    @MainThread
    private WebView onCreateWebView() {
        WebView webView = new WebView(this.mContext);
        webView.setBackgroundColor(this.mBackground);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int progress) {
                Offerwall.this.onProgressUpdate(progress);
            }

            public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
                if (Offerwall.this.mOwner != null) {
                    return Offerwall.this.mOwner.openFileChooser(filePathCallback, fileChooserParams);
                }
                return super.onShowFileChooser(webView, filePathCallback, fileChooserParams);
            }
        });
        webView.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                Offerwall.this.onError(description);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                if (request.isForMainFrame()) {
                    Offerwall.this.onError(error.getDescription().toString());
                }
            }

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                return Offerwall.this.onOverrideUrlLoading(request.getUrl().toString());
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return Offerwall.this.onOverrideUrlLoading(url);
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                Offerwall.this.notifyLoadingStarted();
            }

            public void onPageFinished(WebView view, String url) {
                if (Offerwall.this.mState == 5) {
                    Offerwall.this.setState(6);
                    Offerwall.this.notifyLoadingFinished();
                }
            }
        });
        RealGem.THREAD_POOL.execute(() -> {
            String url = this.mTransport.getOfferwallUrl(this.mSalt);
            Util.runOnMainThread(() -> webView.loadUrl(url));
        });
        return webView;
    }

    @AnyThread
    private void refreshState(boolean force) {
        boolean connected = this.mInternet.isConnected();
        switch (this.mState) {
            case 6: {
                if (connected) break;
                this.mError = Offerwall.createOfflineError();
                this.setState(-2);
                break;
            }
            case -2: {
                if (!connected) break;
                this.setState(6);
                break;
            }
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (!force) break;
                this.setState(connected ? 6 : -2);
            }
        }
    }

    @AnyThread
    private void setState(int newState) {
        Util.runOnMainThread(() -> {
            this.mState = newState;
        });
    }

    private void notifyLoadingStarted() {
        for (OfferwallCallback callback : this.mCallbacks) {
            callback.onOfferwallLoadingStarted();
        }
    }

    private void notifyLoadingFinished() {
        for (OfferwallCallback callback : this.mCallbacks) {
            callback.onOfferwallLoadingFinished();
        }
    }

    private void notifyFailedToLoad(String error) {
        for (OfferwallCallback callback : this.mCallbacks) {
            callback.onOfferwallLoadingFailed(error);
        }
    }

    private void notifyRewardReceived(int amount) {
        for (OfferwallCallback callback : this.mCallbacks) {
            callback.onOfferwallRewardReceived(amount);
        }
    }

    private void notifyClosed() {
        for (OfferwallCallback callback : this.mCallbacks) {
            callback.onOfferwallClosed();
        }
    }

    private void onProgressUpdate(int progress) {
        if (this.mOwner != null) {
            this.setState(5);
        }
    }

    private void onError(String message) {
        if (this.mState == 5) {
            this.mError = Error.withMessage(message);
            this.setState(-2);
            this.notifyFailedToLoad(message);
        }
        if (this.mOwner != null) {
            this.mOwner.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @MainThread
    private boolean onOverrideUrlLoading(String url) {
        boolean intercept;
        Uri uri = Uri.parse((String)url);
        OfferwallPresenter owner = this.mOwner;
        if ("adgem".equals(uri.getScheme())) {
            intercept = true;
            String data = uri.getHost();
            if (data == null) return intercept;
            switch (data) {
                case "close": {
                    if (owner == null) return intercept;
                    owner.close();
                    this.close(owner);
                    return intercept;
                }
                default: {
                    this.onAdGemCallback(data);
                }
            }
            return intercept;
        } else {
            if ("adunits.adgem.com".equals(uri.getHost())) {
                return false;
            }
            if (owner == null) return false;
            boolean bl = true;
            intercept = bl;
            if (!bl) return intercept;
            owner.openUrl(uri);
        }
        return intercept;
    }

    @MainThread
    private void onAdGemCallback(String data) {
        AdGemAction adGemAction = AdGemAction.parse(data);
        if (adGemAction != null && this.mOwner != null) {
            if (adGemAction instanceof AdGemAction.OpenBrowserGemAction) {
                AdGemAction.OpenBrowserGemAction browserAction = (AdGemAction.OpenBrowserGemAction)adGemAction;
                this.mOfferChecker.onOfferClick();
                this.mOwner.openUrl(Uri.parse((String)browserAction.url));
            } else if (adGemAction instanceof AdGemAction.OpenPlayStoreGemAction) {
                AdGemAction.OpenPlayStoreGemAction openPlayStoreActionAction = (AdGemAction.OpenPlayStoreGemAction)adGemAction;
                this.mOfferChecker.onOfferClick();
                this.mOwner.openPlayStore(openPlayStoreActionAction.appId);
                this.mTransport.followRedirects(openPlayStoreActionAction.url);
            } else if (adGemAction instanceof AdGemAction.Reward) {
                AdGemAction.Reward rewardAction = (AdGemAction.Reward)adGemAction;
                this.mOfferChecker.consumeReward(rewardAction);
            } else {
                RealGem.logError("Unknown AdGem redirect");
            }
        }
    }

    @WorkerThread
    private static String generateSalt() {
        char[] allowedChars = "ABCDEF012GHIJKL345MNOPQR678STUVWXYZ9".toCharArray();
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            sb.append(allowedChars[random.nextInt(allowedChars.length)]);
        }
        return sb.toString();
    }

    private static Error createOfflineError() {
        return Error.withMessage("No internet connectivity");
    }

    public static interface OfferwallPresenter {
        public void close();

        public void openUrl(Uri var1);

        public void openPlayStore(String var1);

        public boolean openFileChooser(ValueCallback<Uri[]> var1, WebChromeClient.FileChooserParams var2);
    }
}

