/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal.offerwall;

import android.app.Activity;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.adgem.android.AdGem;
import com.adgem.android.OfferwallCallback;
import com.adgem.android.internal.AdGemActivity;
import com.adgem.android.internal.RealGem;
import com.adgem.android.internal.Util;
import com.adgem.android.internal.offerwall.Offerwall;

public final class OfferwallActivity
extends AdGemActivity
implements Offerwall.OfferwallPresenter,
OfferwallCallback {
    private static final int REQUEST_CODE_OPEN_FILE_CHOOSER = 1;
    private final Offerwall mOfferwall = RealGem.get().getOfferWall();
    private final AdGem mAdGem = AdGem.get();
    private WebView mWebView;
    private ValueCallback<Uri[]> mFilePathCallback;

    public static void start(Context context) {
        Intent intent = new Intent(context, OfferwallActivity.class);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        switch (this.mOfferwall.getState()) {
            case 5: 
            case 6: {
                this.mWebView = this.mOfferwall.open(this);
                this.mAdGem.registerOfferwallCallback(this);
                FrameLayout container = new FrameLayout((Context)this);
                container.addView((View)this.mWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                ViewCompat.setOnApplyWindowInsetsListener((View)container, (v, insets) -> {
                    Insets systemInsets = insets.getInsets(WindowInsetsCompat.Type.systemBars());
                    Insets cameraCutoutInsets = insets.getInsets(WindowInsetsCompat.Type.displayCutout());
                    v.setPadding(systemInsets.left, cameraCutoutInsets.top, systemInsets.right, systemInsets.bottom);
                    return insets;
                });
                this.getWindow().setBackgroundDrawable(this.mWebView.getBackground());
                this.setContentView((View)container);
                break;
            }
            case -1: {
                Log.e((String)"AdGem", (String)"Offer wall is disabled. Check your AdGem config.");
                this.finish();
                break;
            }
            case -2: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Log.e((String)"AdGem", (String)"Could not start offer wall while it's not ready.");
                this.finish();
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mAdGem.unregisterOfferwallCallback(this);
        if (this.isFinishing()) {
            this.mOfferwall.close(this);
        }
    }

    @Override
    public void close() {
        this.finish();
    }

    @Override
    public void openUrl(Uri uri) {
        Util.openBrowser(this, uri);
    }

    @Override
    public void openPlayStore(String packageName) {
        Util.openPlayStore(this, packageName);
    }

    @Override
    public boolean openFileChooser(ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
        if (this.mFilePathCallback != null) {
            this.mFilePathCallback.onReceiveValue(null);
        }
        this.mFilePathCallback = filePathCallback;
        this.startActivityForResult(fileChooserParams.createIntent(), 1);
        return true;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1 && this.mFilePathCallback != null) {
            if (resultCode == -1) {
                ClipData clipData = data.getClipData();
                if (clipData != null) {
                    int itemCount = clipData.getItemCount();
                    if (itemCount > 0) {
                        Uri[] uris = new Uri[itemCount];
                        for (int i = 0; i < itemCount; ++i) {
                            uris[i] = clipData.getItemAt(i).getUri();
                        }
                        this.mFilePathCallback.onReceiveValue((Object)uris);
                    } else {
                        this.mFilePathCallback.onReceiveValue(null);
                    }
                } else {
                    this.mFilePathCallback.onReceiveValue((Object)WebChromeClient.FileChooserParams.parseResult((int)resultCode, (Intent)data));
                }
            } else {
                this.mFilePathCallback.onReceiveValue(null);
            }
            this.mFilePathCallback = null;
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onBackPressed() {
        if (this.mWebView != null && this.mWebView.canGoBack()) {
            this.mWebView.goBack();
        }
        super.onBackPressed();
    }

    @Override
    public void onOfferwallClosed() {
        if (!this.isFinishing()) {
            Log.e((String)"AdGem", (String)"Shutting down offer wall.");
            this.finish();
        }
    }
}

