/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal.tracking;

import android.content.Context;
import androidx.annotation.WorkerThread;
import com.adgem.android.internal.SingletonReference;
import com.adgem.android.internal.tracking.GoogleAdvertisingIdClient;

public final class AdTracking {
    private final Context mContext;
    private final SingletonReference<GoogleAdvertisingIdClient, Context> mGoogleAdvertisingIdClient = new SingletonReference<GoogleAdvertisingIdClient, Context>(GoogleAdvertisingIdClient::new);

    public AdTracking(Context context) {
        this.mContext = context.getApplicationContext();
    }

    @WorkerThread
    public boolean isGoogleAdTrackingEnabled() {
        return !this.mGoogleAdvertisingIdClient.get(this.mContext).getAdvertisingIdInfo().isLimitAdTrackingEnabled();
    }

    @WorkerThread
    public String getGoogleAdvertisingId() {
        return this.mGoogleAdvertisingIdClient.get(this.mContext).getAdvertisingIdInfo().getId();
    }
}

