/*
 * Decompiled with CFR 0.152.
 */
package com.adgem.android.internal.tracking;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.adgem.android.internal.RealGem;
import java.lang.reflect.Method;

final class GoogleAdvertisingIdClient {
    private final Class mAdvertisingIdClientClass;
    private final Context mContext;

    GoogleAdvertisingIdClient(Context context) {
        Class<?> advertisingIdClient;
        this.mContext = context.getApplicationContext();
        try {
            advertisingIdClient = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
        }
        catch (ClassNotFoundException e) {
            advertisingIdClient = null;
        }
        this.mAdvertisingIdClientClass = advertisingIdClient;
        this.setShouldSkipGmsCoreVersionCheck(true);
    }

    @NonNull
    Info getAdvertisingIdInfo() {
        Object info = null;
        if (this.mAdvertisingIdClientClass != null) {
            try {
                info = this.mAdvertisingIdClientClass.getMethod("getAdvertisingIdInfo", Context.class).invoke(null, this.mContext);
            }
            catch (Exception e) {
                RealGem.logError("Could not getAdvertisingIdInfo", e);
            }
        }
        return new Info(info);
    }

    private void setShouldSkipGmsCoreVersionCheck(boolean skip) {
        if (this.mAdvertisingIdClientClass != null) {
            try {
                this.mAdvertisingIdClientClass.getMethod("setShouldSkipGmsCoreVersionCheck", Boolean.TYPE).invoke(null, skip);
            }
            catch (Exception e) {
                RealGem.logError("Could not setShouldSkipGmsCoreVersionCheck", e);
            }
        }
    }

    static final class Info {
        private final Object mProxy;
        private final Method mIsLimitAdTrackingEnabledMethod;
        private final Method mGetIdMethod;

        private Info(@Nullable Object proxy) {
            this.mProxy = proxy;
            Method isLimitAdTrackingEnabledMethod = null;
            Method getIdMethod = null;
            if (this.mProxy != null) {
                Class<?> clazz = this.mProxy.getClass();
                try {
                    isLimitAdTrackingEnabledMethod = clazz.getMethod("isLimitAdTrackingEnabled", new Class[0]);
                    getIdMethod = clazz.getMethod("getId", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            this.mIsLimitAdTrackingEnabledMethod = isLimitAdTrackingEnabledMethod;
            this.mGetIdMethod = getIdMethod;
        }

        boolean isLimitAdTrackingEnabled() {
            boolean limitAdTrackingEnabled = true;
            if (this.mProxy != null && this.mIsLimitAdTrackingEnabledMethod != null) {
                try {
                    limitAdTrackingEnabled = (Boolean)this.mIsLimitAdTrackingEnabledMethod.invoke(this.mProxy, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return limitAdTrackingEnabled;
        }

        String getId() {
            String id = null;
            if (this.mProxy != null && this.mGetIdMethod != null) {
                try {
                    id = (String)this.mGetIdMethod.invoke(this.mProxy, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return id;
        }
    }
}

