/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import com.adjust.sdk.ActivityKind;
import com.adjust.sdk.Util;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ActivityPackage
implements Serializable {
    private static final long serialVersionUID = -35935556512024097L;
    private static final ObjectStreamField[] serialPersistentFields;
    private transient int hashCode;
    private String path;
    private String clientSdk;
    private Map<String, String> parameters;
    private ActivityKind activityKind;
    private String suffix;
    private Map<String, String> callbackParameters;
    private Map<String, String> partnerParameters;
    private int retries;
    private long clickTimeInMilliseconds;
    private long clickTimeInSeconds;
    private long installBeginTimeInSeconds;
    private long clickTimeServerInSeconds;
    private long installBeginTimeServerInSeconds;
    private String installVersion;
    private Boolean googlePlayInstant;

    public ActivityPackage(ActivityKind activityKind) {
        this.activityKind = activityKind;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream object) {
        object = ((ObjectInputStream)object).readFields();
        this.path = Util.readStringField((ObjectInputStream.GetField)object, "path", null);
        this.clientSdk = Util.readStringField((ObjectInputStream.GetField)object, "clientSdk", null);
        this.parameters = Util.readObjectField((ObjectInputStream.GetField)object, "parameters", null);
        this.activityKind = Util.readObjectField((ObjectInputStream.GetField)object, "activityKind", ActivityKind.UNKNOWN);
        this.suffix = Util.readStringField((ObjectInputStream.GetField)object, "suffix", null);
        this.callbackParameters = Util.readObjectField((ObjectInputStream.GetField)object, "callbackParameters", null);
        this.partnerParameters = Util.readObjectField((ObjectInputStream.GetField)object, "partnerParameters", null);
    }

    static {
        ObjectStreamField objectStreamField;
        ObjectStreamField objectStreamField2;
        ObjectStreamField objectStreamField3;
        ObjectStreamField objectStreamField4;
        ObjectStreamField objectStreamField5;
        ObjectStreamField objectStreamField6;
        ObjectStreamField objectStreamField7;
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[7];
        ObjectStreamField objectStreamField8 = objectStreamField7;
        objectStreamField7 = new ObjectStreamField("path", String.class);
        objectStreamFieldArray[0] = objectStreamField8;
        objectStreamField8 = objectStreamField6;
        objectStreamField6 = new ObjectStreamField("clientSdk", String.class);
        objectStreamFieldArray[1] = objectStreamField8;
        objectStreamField8 = objectStreamField5;
        objectStreamField5 = new ObjectStreamField("parameters", Map.class);
        objectStreamFieldArray[2] = objectStreamField8;
        objectStreamField8 = objectStreamField4;
        objectStreamField4 = new ObjectStreamField("activityKind", ActivityKind.class);
        objectStreamFieldArray[3] = objectStreamField8;
        objectStreamField8 = objectStreamField3;
        objectStreamField3 = new ObjectStreamField("suffix", String.class);
        objectStreamFieldArray[4] = objectStreamField8;
        objectStreamField8 = objectStreamField2;
        objectStreamField2 = new ObjectStreamField("callbackParameters", Map.class);
        objectStreamFieldArray[5] = objectStreamField8;
        objectStreamField8 = objectStreamField;
        objectStreamField = new ObjectStreamField("partnerParameters", Map.class);
        objectStreamFieldArray[6] = objectStreamField8;
        serialPersistentFields = objectStreamFieldArray;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getClientSdk() {
        return this.clientSdk;
    }

    public void setClientSdk(String string) {
        this.clientSdk = string;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> map) {
        this.parameters = map;
    }

    public void setCallbackParameters(Map<String, String> map) {
        this.callbackParameters = map;
    }

    public void setPartnerParameters(Map<String, String> map) {
        this.partnerParameters = map;
    }

    public ActivityKind getActivityKind() {
        return this.activityKind;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }

    public int getRetries() {
        return this.retries;
    }

    public int increaseRetries() {
        return ++this.retries;
    }

    public long getClickTimeInMilliseconds() {
        return this.clickTimeInMilliseconds;
    }

    public void setClickTimeInMilliseconds(long l2) {
        this.clickTimeInMilliseconds = l2;
    }

    public long getClickTimeInSeconds() {
        return this.clickTimeInSeconds;
    }

    public void setClickTimeInSeconds(long l2) {
        this.clickTimeInSeconds = l2;
    }

    public long getInstallBeginTimeInSeconds() {
        return this.installBeginTimeInSeconds;
    }

    public void setInstallBeginTimeInSeconds(long l2) {
        this.installBeginTimeInSeconds = l2;
    }

    public long getClickTimeServerInSeconds() {
        return this.clickTimeServerInSeconds;
    }

    public void setClickTimeServerInSeconds(long l2) {
        this.clickTimeServerInSeconds = l2;
    }

    public long getInstallBeginTimeServerInSeconds() {
        return this.installBeginTimeServerInSeconds;
    }

    public void setInstallBeginTimeServerInSeconds(long l2) {
        this.installBeginTimeServerInSeconds = l2;
    }

    public String getInstallVersion() {
        return this.installVersion;
    }

    public void setInstallVersion(String string) {
        this.installVersion = string;
    }

    public Boolean getGooglePlayInstant() {
        return this.googlePlayInstant;
    }

    public void setGooglePlayInstant(Boolean bl) {
        this.googlePlayInstant = bl;
    }

    public Map<String, String> getCallbackParameters() {
        return this.callbackParameters;
    }

    public Map<String, String> getPartnerParameters() {
        return this.partnerParameters;
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.activityKind.toString();
        objectArray[1] = this.suffix;
        return Util.formatString("%s%s", objectArray2);
    }

    public String getExtendedString() {
        List<String> list;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        Object[] objectArray = new Object[1];
        Object object = objectArray;
        objectArray[0] = ((ActivityPackage)((Object)list)).path;
        new StringBuilder().append(Util.formatString("Path:      %s\n", (Object[])object));
        Object[] objectArray2 = new Object[1];
        object = objectArray2;
        objectArray2[0] = ((ActivityPackage)((Object)list)).clientSdk;
        stringBuilder2.append(Util.formatString("ClientSdk: %s\n", (Object[])object));
        if (((ActivityPackage)((Object)list)).parameters != null) {
            stringBuilder2.append("Parameters:");
            list = Arrays.asList("app_secret", "secret_id", "event_callback_id");
            for (Map.Entry entry : new TreeMap<String, String>(((ActivityPackage)((Object)list)).parameters).entrySet()) {
                String string = (String)entry.getKey();
                if (list.contains(string)) continue;
                Object[] objectArray3 = new Object[2];
                Object[] objectArray4 = objectArray3;
                objectArray4[0] = string;
                objectArray3[1] = entry.getValue();
                stringBuilder2.append(Util.formatString("\n\t%-16s %s", objectArray4));
            }
        }
        return stringBuilder2.toString();
    }

    public String getFailureMessage() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.activityKind.toString();
        objectArray[1] = this.suffix;
        return Util.formatString("Failed to track %s%s", objectArray2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (ActivityPackage)object;
        if (!Util.equalString(this.path, ((ActivityPackage)object).path)) {
            return false;
        }
        if (!Util.equalString(this.clientSdk, ((ActivityPackage)object).clientSdk)) {
            return false;
        }
        if (!Util.equalObject(this.parameters, ((ActivityPackage)object).parameters)) {
            return false;
        }
        if (!Util.equalEnum(this.activityKind, ((ActivityPackage)object).activityKind)) {
            return false;
        }
        if (!Util.equalString(this.suffix, ((ActivityPackage)object).suffix)) {
            return false;
        }
        if (!Util.equalObject(this.callbackParameters, ((ActivityPackage)object).callbackParameters)) {
            return false;
        }
        return Util.equalObject(this.partnerParameters, ((ActivityPackage)object).partnerParameters);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            ActivityPackage activityPackage = this;
            activityPackage.hashCode = 17;
            int n2 = 17 * 37;
            this.hashCode = Util.hashString(activityPackage.path) + n2;
            n2 = this.hashCode * 37;
            this.hashCode = Util.hashString(activityPackage.clientSdk) + n2;
            n2 = this.hashCode * 37;
            this.hashCode = Util.hashObject(activityPackage.parameters) + n2;
            n2 = this.hashCode * 37;
            this.hashCode = Util.hashEnum(activityPackage.activityKind) + n2;
            n2 = this.hashCode * 37;
            this.hashCode = Util.hashString(activityPackage.suffix) + n2;
            n2 = this.hashCode * 37;
            this.hashCode = Util.hashObject(activityPackage.callbackParameters) + n2;
            n2 = this.hashCode * 37;
            activityPackage.hashCode = Util.hashObject(activityPackage.partnerParameters) + n2;
        }
        return this.hashCode;
    }
}

