/*
 * Decompiled with CFR 0.152.
 */
package com.adjust.sdk;

import android.content.Context;
import com.adjust.sdk.AdjustFactory;
import com.adjust.sdk.ILogger;
import com.adjust.sdk.InstallReferrerReadListener;
import com.adjust.sdk.ReferrerDetails;
import com.adjust.sdk.Reflection;
import com.adjust.sdk.Util;
import com.adjust.sdk.scheduler.SingleThreadCachedScheduler;
import com.adjust.sdk.scheduler.ThreadExecutor;
import com.adjust.sdk.scheduler.TimerOnce;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicBoolean;

public class InstallReferrer
implements InvocationHandler {
    private static final String PACKAGE_BASE_NAME = "com.android.installreferrer.";
    private static final int STATUS_SERVICE_DISCONNECTED = -1;
    private static final int STATUS_OK = 0;
    private static final int STATUS_SERVICE_UNAVAILABLE = 1;
    private static final int STATUS_FEATURE_NOT_SUPPORTED = 2;
    private static final int STATUS_DEVELOPER_ERROR = 3;
    private int retryWaitTime;
    private int retries;
    private final AtomicBoolean shouldTryToRead;
    private ILogger logger;
    private Object referrerClient;
    private Context context;
    private TimerOnce retryTimer;
    private final InstallReferrerReadListener referrerCallback;
    private Object playInstallReferrer;
    private ThreadExecutor executor;

    public InstallReferrer(Context object, InstallReferrerReadListener installReferrerReadListener) {
        InstallReferrer installReferrer = this;
        InstallReferrer installReferrer2 = this;
        Context context = object;
        Context context2 = object;
        this.retryWaitTime = 3000;
        object = AdjustFactory.getLogger();
        this.logger = object;
        this.playInstallReferrer = this.createInstallReferrer(context2, installReferrerReadListener, (ILogger)object);
        installReferrer2.context = context;
        installReferrer2.shouldTryToRead = new AtomicBoolean(true);
        installReferrer2.retries = 0;
        installReferrer2.retryTimer = new TimerOnce(new Runnable(){

            @Override
            public final void run() {
                InstallReferrer.this.startConnection();
            }
        }, "InstallReferrer");
        installReferrer.referrerCallback = installReferrerReadListener;
        installReferrer.executor = new SingleThreadCachedScheduler("InstallReferrer");
    }

    private Object createInstallReferrer(Context context, InstallReferrerReadListener installReferrerReadListener, ILogger iLogger) {
        Class[] classArray = new Class[3];
        Class[] classArray2 = classArray;
        classArray[0] = Context.class;
        classArray[1] = InstallReferrerReadListener.class;
        classArray[2] = ILogger.class;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = context;
        objectArray[1] = installReferrerReadListener;
        objectArray[2] = iLogger;
        return Reflection.createInstance("com.adjust.sdk.play.InstallReferrer", classArray2, objectArray2);
    }

    private Object createInstallReferrerClient(Context context) {
        Object[] objectArray;
        String string = "com.android.installreferrer.api.InstallReferrerClient";
        String string2 = "newBuilder";
        Class[] classArray = new Class[1];
        classArray[0] = Context.class;
        Object object = Reflection.invokeStaticMethod(string, string2, classArray, context);
        String string3 = "build";
        try {
            return Reflection.invokeInstanceMethod(object, string3, null, new Object[0]);
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = exception.getMessage();
            objectArray2[1] = exception.getClass().getCanonicalName();
            objectArray.logger.error("createInstallReferrerClient error (%s) from (%s)", objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray[0] = classNotFoundException.getMessage();
            objectArray3[1] = classNotFoundException.getClass().getCanonicalName();
            objectArray.logger.warn("InstallReferrer not integrated in project (%s) thrown by (%s)", objectArray);
        }
        return null;
    }

    private Class getInstallReferrerStateListenerClass() {
        try {
            return Class.forName("com.android.installreferrer.api.InstallReferrerStateListener");
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = exception.getMessage();
            objectArray[1] = exception.getClass().getCanonicalName();
            objectArray2.logger.error("getInstallReferrerStateListenerClass error (%s) from (%s)", objectArray2);
            return null;
        }
    }

    private Object createProxyInstallReferrerStateListener(Class clazz) {
        Object object = null;
        try {
            object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
        }
        catch (NullPointerException nullPointerException) {
            this.logger.error("Null argument passed to InstallReferrer proxy", new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.error("InstallReferrer proxy violating parameter restrictions", new Object[0]);
        }
        return object;
    }

    private void startConnection(Class objectArray, Object object) {
        block4: {
            Object[] objectArray2;
            Object object2 = objectArray2.referrerClient;
            String string = "startConnection";
            Class[] classArray = new Class[1];
            Class[] classArray2 = classArray;
            classArray[0] = objectArray;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            try {
                objectArray3[0] = object;
                Reflection.invokeInstanceMethod(object2, string, classArray2, objectArray);
            }
            catch (Exception exception) {
                Object[] objectArray4 = new Object[2];
                objectArray2 = objectArray4;
                objectArray2[0] = exception.getMessage();
                objectArray4[1] = exception.getClass().getCanonicalName();
                objectArray2.logger.error("startConnection error (%s) thrown by (%s)", objectArray2);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (!Util.hasRootCause(invocationTargetException)) break block4;
                Object[] objectArray5 = new Object[1];
                objectArray2 = objectArray5;
                objectArray5[0] = Util.getRootCause(invocationTargetException);
                objectArray2.logger.error("InstallReferrer encountered an InvocationTargetException %s", objectArray2);
            }
        }
    }

    private Object invokeI(Object object, Method objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            objectArray7.logger.error("InstallReferrer invoke method null", new Object[0]);
            return null;
        }
        object = objectArray.getName();
        if (object == null) {
            objectArray7.logger.error("InstallReferrer invoke method name null", new Object[0]);
            return null;
        }
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = object;
        objectArray7.logger.debug("InstallReferrer invoke method name: %s", objectArray);
        if (objectArray2 == null) {
            objectArray7.logger.warn("InstallReferrer invoke args null", new Object[0]);
            objectArray2 = new Object[]{};
        }
        int n2 = objectArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = objectArray2[i2];
            Object[] objectArray4 = new Object[1];
            Object[] objectArray5 = objectArray4;
            objectArray4[0] = object2;
            objectArray7.logger.debug("InstallReferrer invoke arg: %s", objectArray5);
        }
        if (((String)object).equals("onInstallReferrerSetupFinished")) {
            if (objectArray2.length != 1) {
                Object[] objectArray6 = new Object[1];
                Object[] objectArray7 = objectArray6;
                objectArray6[0] = objectArray2.length;
                objectArray7.logger.error("InstallReferrer invoke onInstallReferrerSetupFinished args lenght not 1: %d", objectArray7);
                return null;
            }
            object = objectArray2[0];
            if (!(object instanceof Integer)) {
                objectArray7.logger.error("InstallReferrer invoke onInstallReferrerSetupFinished arg not int", new Object[0]);
                return null;
            }
            if ((object = (Integer)object) == null) {
                objectArray7.logger.error("InstallReferrer invoke onInstallReferrerSetupFinished responseCode arg is null", new Object[0]);
                return null;
            }
            super.onInstallReferrerSetupFinishedIntI((Integer)object);
        } else if (((String)object).equals("onInstallReferrerServiceDisconnected")) {
            objectArray7.logger.debug("Connection to install referrer service was lost. Retrying ...", new Object[0]);
            super.retryI();
        }
        return null;
    }

    private void onInstallReferrerSetupFinishedIntI(int n2) {
        boolean bl = false;
        switch (n2) {
            default: {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = n2;
                this.logger.debug("Unexpected response code of install referrer response: %d. Closing connection", objectArray2);
                break;
            }
            case 3: {
                this.logger.debug("Install Referrer API general errors caused by incorrect usage. Retrying...", new Object[0]);
                bl = true;
                break;
            }
            case 2: {
                this.logger.debug("Install Referrer API not supported by the installed Play Store app. Closing connection", new Object[0]);
                break;
            }
            case 1: {
                this.logger.debug("Could not initiate connection to the Install Referrer service. Retrying...", new Object[0]);
                bl = true;
                break;
            }
            case 0: {
                ReferrerDetails referrerDetails;
                InstallReferrer installReferrer = this;
                InstallReferrer installReferrer2 = installReferrer;
                InstallReferrer installReferrer3 = installReferrer;
                InstallReferrer installReferrer4 = installReferrer;
                InstallReferrer installReferrer5 = installReferrer;
                InstallReferrer installReferrer6 = installReferrer;
                InstallReferrer installReferrer7 = installReferrer;
                InstallReferrer installReferrer8 = installReferrer;
                InstallReferrer installReferrer9 = installReferrer;
                InstallReferrer installReferrer10 = installReferrer;
                InstallReferrer installReferrer11 = installReferrer;
                Object object = installReferrer.getInstallReferrer();
                String string = installReferrer9.getStringInstallReferrer(object);
                long l2 = installReferrer10.getReferrerClickTimestampSeconds(object);
                long l3 = installReferrer11.getInstallBeginTimestampSeconds(object);
                Object object2 = object;
                ILogger iLogger = this.logger;
                String string2 = "installReferrer: %s, clickTime: %d, installBeginTime: %d";
                Object[] objectArray = new Object[3];
                Object[] objectArray3 = objectArray;
                long l4 = l3;
                Object[] objectArray4 = objectArray3;
                long l5 = l2;
                objectArray3[0] = string;
                int n3 = 1;
                objectArray4[n3] = l5;
                n3 = 2;
                objectArray[n3] = l4;
                iLogger.debug(string2, objectArray);
                String string3 = installReferrer7.getStringInstallVersion(object2);
                long l6 = installReferrer8.getReferrerClickTimestampServerSeconds(object);
                long l7 = installReferrer5.getInstallBeginTimestampServerSeconds(object);
                object = installReferrer6.getBooleanGooglePlayInstantParam(object);
                ILogger iLogger2 = installReferrer3.logger;
                String string4 = "installVersion: %s, clickTimeServer: %d, installBeginServer: %d, googlePlayInstant: %b";
                Object[] objectArray5 = new Object[4];
                Object[] objectArray6 = objectArray5;
                long l8 = l7;
                Object[] objectArray7 = objectArray6;
                long l9 = l6;
                objectArray6[0] = string3;
                int n4 = 1;
                objectArray7[n4] = l9;
                n4 = 2;
                objectArray5[n4] = l8;
                objectArray5[3] = object;
                iLogger2.debug(string4, objectArray5);
                installReferrer4.logger.debug("Install Referrer read successfully. Closing connection", new Object[0]);
                ReferrerDetails referrerDetails2 = referrerDetails;
                try {
                    referrerDetails = new ReferrerDetails(string, l2, l3, l6, l7, string3, (Boolean)object);
                    installReferrer2.referrerCallback.onInstallReferrerRead(referrerDetails2, "google");
                }
                catch (Exception exception) {
                    Object[] objectArray8 = new Object[1];
                    Object[] objectArray9 = objectArray8;
                    objectArray8[0] = exception.getMessage();
                    this.logger.warn("Couldn't get install referrer from client (%s). Retrying...", objectArray9);
                    bl = true;
                }
                break;
            }
            case -1: {
                this.logger.debug("Play Store service is not connected now. Retrying...", new Object[0]);
                bl = true;
            }
        }
        if (bl) {
            this.retryI();
        } else {
            InstallReferrer installReferrer = this;
            installReferrer.shouldTryToRead.set(false);
            installReferrer.closeReferrerClient();
        }
    }

    private Object getInstallReferrer() {
        String string;
        Object object;
        Object object2 = objectArray2.referrerClient;
        if (object2 == null) {
            return null;
        }
        try {
            object = object2;
            string = "getInstallReferrer";
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = exception.getMessage();
            objectArray[1] = exception.getClass().getCanonicalName();
            objectArray2.logger.error("getInstallReferrer error (%s) thrown by (%s)", objectArray2);
            return null;
        }
        return Reflection.invokeInstanceMethod(object, string, null, new Object[0]);
    }

    private String getStringInstallReferrer(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return null;
        }
        try {
            object2 = object;
            string = "getInstallReferrer";
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = exception.getMessage();
            objectArray[1] = exception.getClass().getCanonicalName();
            objectArray2.logger.error("getStringInstallReferrer error (%s) thrown by (%s)", objectArray2);
            return null;
        }
        return (String)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private long getReferrerClickTimestampSeconds(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return -1L;
        }
        try {
            object2 = object;
            string = "getReferrerClickTimestampSeconds";
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = exception.getMessage();
            objectArray[1] = exception.getClass().getCanonicalName();
            objectArray2.logger.error("getReferrerClickTimestampSeconds error (%s) thrown by (%s)", objectArray2);
            return -1L;
        }
        return (Long)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private long getInstallBeginTimestampSeconds(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return -1L;
        }
        try {
            object2 = object;
            string = "getInstallBeginTimestampSeconds";
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = exception.getMessage();
            objectArray[1] = exception.getClass().getCanonicalName();
            objectArray2.logger.error("getInstallBeginTimestampSeconds error (%s) thrown by (%s)", objectArray2);
            return -1L;
        }
        return (Long)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private String getStringInstallVersion(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return null;
        }
        try {
            object2 = object;
            string = "getInstallVersion";
        }
        catch (Exception exception) {
            return null;
        }
        return (String)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private long getReferrerClickTimestampServerSeconds(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return -1L;
        }
        try {
            object2 = object;
            string = "getReferrerClickTimestampServerSeconds";
        }
        catch (Exception exception) {
            return -1L;
        }
        return (Long)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private long getInstallBeginTimestampServerSeconds(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return -1L;
        }
        try {
            object2 = object;
            string = "getInstallBeginTimestampServerSeconds";
        }
        catch (Exception exception) {
            return -1L;
        }
        return (Long)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
    }

    private Boolean getBooleanGooglePlayInstantParam(Object object) {
        String string;
        Object object2;
        if (object == null) {
            return null;
        }
        try {
            object2 = object;
            string = "getGooglePlayInstantParam";
        }
        catch (Exception exception) {
            return null;
        }
        return (boolean)((Boolean)Reflection.invokeInstanceMethod(object2, string, null, new Object[0]));
    }

    private void retryI() {
        int n2;
        Object[] objectArray;
        if (!objectArray.shouldTryToRead.get()) {
            objectArray.logger.debug("Should not try to read Install referrer", new Object[0]);
            objectArray.closeReferrerClient();
            return;
        }
        if (objectArray.retries + 1 > 2) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = 2;
            objectArray.logger.debug("Limit number of retry of %d for install referrer surpassed", objectArray);
            return;
        }
        long l2 = objectArray.retryTimer.getFireIn();
        if (l2 > 0L) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = l2;
            objectArray.logger.debug("Already waiting to retry to read install referrer in %d milliseconds", objectArray);
            return;
        }
        objectArray.retries = n2 = objectArray.retries + 1;
        Object[] objectArray4 = new Object[1];
        Object[] objectArray5 = objectArray4;
        objectArray4[0] = n2;
        objectArray.logger.debug("Retry number %d to connect to install referrer API", objectArray5);
        objectArray.retryTimer.startIn(objectArray.retryWaitTime);
    }

    private void closeReferrerClient() {
        Object object = this.referrerClient;
        if (object == null) {
            return;
        }
        InstallReferrer installReferrer = this;
        Object object2 = object;
        String string = "endConnection";
        Reflection.invokeInstanceMethod(object2, string, null, new Object[0]);
        try {
            installReferrer.logger.debug("Install Referrer API connection closed", new Object[0]);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = exception.getMessage();
            objectArray[1] = exception.getClass().getCanonicalName();
            this.logger.error("closeReferrerClient error (%s) thrown by (%s)", objectArray2);
        }
        this.referrerClient = null;
    }

    public void startConnection() {
        Object object;
        Object object2 = this.playInstallReferrer;
        if (object2 != null) {
            Object object3 = object2;
            object2 = "startConnection";
            object = new Object[]{};
            try {
                Reflection.invokeInstanceMethod(object3, (String)object2, null, object);
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                object = objectArray;
                objectArray[0] = exception.getMessage();
                this.logger.error("Call to Play startConnection error: %s", object);
            }
            return;
        }
        if (!AdjustFactory.getTryInstallReferrer()) {
            return;
        }
        InstallReferrer installReferrer = this;
        installReferrer.closeReferrerClient();
        if (!installReferrer.shouldTryToRead.get()) {
            this.logger.debug("Should not try to read Install referrer", new Object[0]);
            return;
        }
        object2 = this.context;
        if (object2 == null) {
            return;
        }
        this.referrerClient = this.createInstallReferrerClient((Context)object2);
        if (this.referrerClient == null) {
            return;
        }
        object2 = this.getInstallReferrerStateListenerClass();
        if (object2 == null) {
            return;
        }
        object = this.createProxyInstallReferrerStateListener((Class)object2);
        if (object == null) {
            return;
        }
        this.startConnection((Class)object2, object);
    }

    @Override
    public Object invoke(final Object object, final Method method, final Object[] objectArray) {
        this.executor.submit(new Runnable(){

            @Override
            public final void run() {
                InstallReferrer installReferrer = objectArray5.InstallReferrer.this;
                Object[] objectArray6 = objectArray5;
                Object[] objectArray2 = objectArray5;
                Object object2 = objectArray5.object;
                Method method2 = objectArray2.method;
                Object[] objectArray3 = objectArray6.objectArray;
                try {
                    installReferrer.invokeI(object2, method2, objectArray3);
                }
                catch (Throwable throwable) {
                    Object[] objectArray4 = new Object[2];
                    Object[] objectArray5 = objectArray4;
                    objectArray5[0] = throwable.getMessage();
                    objectArray4[1] = throwable.getClass().getCanonicalName();
                    objectArray5.InstallReferrer.this.logger.error("invoke error (%s) thrown by (%s)", objectArray5);
                }
            }
        });
        return null;
    }
}

