package com.adlibsoftware.authorize;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
 
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

/**
 * Class for encrypting and decrypting strings with a secret key
 * @author mmanley
 *
 */
public class AES {
 
    private static SecretKeySpec secretKey;
    private static byte[] key;
 
    /**
     * Set the secret key (using for encryption/decryption)
     * @param myKey
     */
    public static void setKey(String myKey) 
    {
        MessageDigest sha = null;
        try {
            key = myKey.getBytes("UTF-8");
            sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16); 
            secretKey = new SecretKeySpec(key, "AES");
        } 
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } 
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
    
    /**
     * Encrypt string using previously set key
     * @param plainText
     * @return
     */
    public static String encrypt(String plainText) {
    	try
        {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, secretKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(plainText.getBytes("UTF-8")));
        } 
        catch (Exception e) 
        {
            System.out.println("Error while encrypting: " + e.toString());
        }
        return null;
    }
 
    /**
     * Encrypt string using secret key
     * @param plainText
     * @param secret
     * @return
     */
    public static String encrypt(String plainText, String secret) 
    {
        try
        {
            setKey(secret);
            return encrypt(plainText);
        } 
        catch (Exception e) 
        {
            System.out.println("Error while encrypting: " + e.toString());
        }
        return null;
    }
 
    /**
     * Decrypt string using secret key
     * @param encrypted
     * @param secret
     * @return
     */
    public static String decrypt(String encrypted, String secret) 
    {
        try
        {
            setKey(secret);
            return decrypt(encrypted);
        } 
        catch (Exception e) 
        {
            //System.out.println("Error while decrypting: " + e.toString());
        }
        return null;
    }
    
    /**
     * Decrypt string using previously set key
     * @param encrypted
     * @return
     */
    public static String decrypt(String encrypted) 
    {
        try
        {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            cipher.init(Cipher.DECRYPT_MODE, secretKey);
            return new String(cipher.doFinal(Base64.getDecoder().decode(encrypted)));
        } 
        catch (Exception e) 
        {
            //System.out.println("Error while decrypting: " + e.toString());
        }
        return null;
    }
}
