
package com.adlibsoftware.client;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for JobStatus.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="JobStatus">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="Initializing"/>
 *     &lt;enumeration value="Ready"/>
 *     &lt;enumeration value="Processing"/>
 *     &lt;enumeration value="Processed"/>
 *     &lt;enumeration value="Completed"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "JobStatus", namespace = "http://schemas.datacontract.org/2004/07/Adlib.Public.Enums.Jobs")
@XmlEnum
public enum JobStatus {

    @XmlEnumValue("Initializing")
    INITIALIZING("Initializing"),
    @XmlEnumValue("Ready")
    READY("Ready"),
    @XmlEnumValue("Processing")
    PROCESSING("Processing"),
    @XmlEnumValue("Processed")
    PROCESSED("Processed"),
    @XmlEnumValue("Completed")
    COMPLETED("Completed");
    private final String value;

    JobStatus(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JobStatus fromValue(String v) {
        for (JobStatus c: JobStatus.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
