
package com.adlibsoftware.client;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for RenditionType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="RenditionType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="Original"/>
 *     &lt;enumeration value="Pdf"/>
 *     &lt;enumeration value="Text"/>
 *     &lt;enumeration value="Thumbnail"/>
 *     &lt;enumeration value="Highlighted"/>
 *     &lt;enumeration value="Redacted"/>
 *     &lt;enumeration value="ConceptRelevanceVector"/>
 *     &lt;enumeration value="Markup"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "RenditionType", namespace = "http://schemas.datacontract.org/2004/07/Adlib.Apps.Identify.Shared.Enums")
@XmlEnum
public enum RenditionType {

    @XmlEnumValue("Original")
    ORIGINAL("Original"),
    @XmlEnumValue("Pdf")
    PDF("Pdf"),
    @XmlEnumValue("Text")
    TEXT("Text"),
    @XmlEnumValue("Thumbnail")
    THUMBNAIL("Thumbnail"),
    @XmlEnumValue("Highlighted")
    HIGHLIGHTED("Highlighted"),
    @XmlEnumValue("Redacted")
    REDACTED("Redacted"),
    @XmlEnumValue("ConceptRelevanceVector")
    CONCEPT_RELEVANCE_VECTOR("ConceptRelevanceVector"),
    @XmlEnumValue("Markup")
    MARKUP("Markup");
    private final String value;

    RenditionType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static RenditionType fromValue(String v) {
        for (RenditionType c: RenditionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
