package com.adlibsoftware.handlers;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import com.adlibsoftware.authorize.TokenAuthorizer;

public class HeaderHandler implements SOAPHandler<SOAPMessageContext> {

	private static final String AUTH_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
	private static final String ASSERTION_NS = "urn:oasis:names:tc:SAML:2.0:assertion";

	private TokenAuthorizer tokenAuthorizer;
	
	public HeaderHandler() {
	}
	
	public HeaderHandler(TokenAuthorizer tokenAuthorizer) {
		this.tokenAuthorizer = tokenAuthorizer;
	}

	public boolean handleFault(SOAPMessageContext smc) {
		return true;
	}

	public void close(MessageContext mc) {
	}

	public boolean handleMessage(SOAPMessageContext soapMessageContext) {
		boolean outbound = ((Boolean) soapMessageContext.get(SOAPMessageContext.MESSAGE_OUTBOUND_PROPERTY))
				.booleanValue();

		if (outbound) {

			try {
				SOAPMessage soapMessage = soapMessageContext.getMessage();
				SOAPEnvelope envelope = soapMessage.getSOAPPart().getEnvelope();
				SOAPFactory soapFactory = SOAPFactory.newInstance();
				// WSSecurity <Security> header
				SOAPElement wsSecHeaderElm = soapFactory.createElement("Security", "", AUTH_NS);
				SOAPElement assertionTokenElm = soapFactory.createElement("Assertion", "", ASSERTION_NS);
				// add child elements to the root element
				assertionTokenElm.addAttribute(soapFactory.createName("ID"),
						String.format("_%s", java.util.UUID.randomUUID()));
				assertionTokenElm.addAttribute(soapFactory.createName("IssueInstant"), getIssueInstant());
				assertionTokenElm.addAttribute(soapFactory.createName("Version"), "2.0");

				SOAPElement issuerElm = soapFactory.createElement(new QName(ASSERTION_NS, "Issuer"));
				issuerElm.addTextNode("urn:wrappedjwt");

				SOAPElement subjectElm = soapFactory.createElement(new QName(ASSERTION_NS, "Subject"));

				SOAPElement subjectConfirmationElm = soapFactory
						.createElement(new QName(ASSERTION_NS, "SubjectConfirmation"));
				subjectConfirmationElm.addAttribute(soapFactory.createName("Method"),
						"urn:oasis:names:tc:SAML:2.0:cm:bearer");

				SOAPElement attributeStatementElm = soapFactory
						.createElement(new QName(ASSERTION_NS, "AttributeStatement"));

				SOAPElement attributeElm = soapFactory.createElement(new QName(ASSERTION_NS, "Attribute"));
				attributeElm.addAttribute(soapFactory.createName("Name"), "jwt");

				SOAPElement attributeValueElm = soapFactory.createElement(new QName(ASSERTION_NS, "AttributeValue"));
				String token = tokenAuthorizer.getToken();
				attributeValueElm.addTextNode(token);

				SOAPHeader soapHeader = envelope.getHeader();
				if (soapHeader == null) {
					soapHeader = envelope.addHeader();
				}

				attributeElm.addChildElement(attributeValueElm);
				attributeStatementElm.addChildElement(attributeElm);
				assertionTokenElm.addChildElement(issuerElm);
				subjectElm.addChildElement(subjectConfirmationElm);
				assertionTokenElm.addChildElement(subjectElm);
				assertionTokenElm.addChildElement(attributeStatementElm);
				wsSecHeaderElm.addChildElement(assertionTokenElm);
				soapHeader.addChildElement(wsSecHeaderElm);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return true;
	}

	private String getIssueInstant() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZ");
		return sdf.format(new Date());
	}

	public java.util.Set<QName> getHeaders() {
		final QName securityHeader = new QName(
				"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security",
				"wsse");

		final HashSet<QName> headers = new HashSet<QName>();
		headers.add(securityHeader);
		return headers;
	}
}
